/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.install.commons.base.prereq.PrereqChecker;
import oracle.install.commons.base.prereq.PrereqCheckerEvent;
import oracle.install.commons.base.prereq.PrereqCheckerListener;
import oracle.install.commons.base.prereq.ui.PrereqCheckerPane;
import oracle.install.commons.swing.BannerFrame;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

public class PrereqCheckerFrame
extends BannerFrame {
    private PrereqCheckerPane prereqCheckerPane = new PrereqCheckerPane();

    public PrereqCheckerFrame() {
        this("", "");
    }

    public PrereqCheckerFrame(String title, String bannerText) {
        super(title);
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.commons.base.prereq.resource.StringResourceBundle");
        if (bannerText == null || bannerText.trim().length() == 0) {
            super.setBannerText(resource.getString("prereqCheckerFrame.bannerText.name", "Perform Prerequisite Checks", new Object[0]));
        }
        JPanel contentPane = new JPanel(new GridBagLayout());
        JButton btnClose = new JButton();
        btnClose.setText(resource.getString("prereqCheckerFrame.btnClose.text", "Close", new Object[0]));
        final Component detailsPane = this.prereqCheckerPane.getDetailsPane();
        detailsPane.setMinimumSize(new Dimension(0, 85));
        detailsPane.setVisible(false);
        LayoutUtils.addComponent(this.prereqCheckerPane, contentPane, 0, 0, 2, 1, 1, 10, 1.0, 1.0, new Insets(0, 0, 0, 0));
        LayoutUtils.addComponent(detailsPane, contentPane, 0, 1, 2, 1, 2, 10, 1.0, 0.0, new Insets(5, 5, 0, 5));
        LayoutUtils.addComponent(Box.createGlue(), contentPane, 0, 2, 1, 1, 2, 17, 1.0, 0.0, new Insets(0, 5, 5, 5));
        LayoutUtils.addComponent(btnClose, contentPane, 1, 2, 1, 1, 0, 13, 0.0, 0.0, new Insets(5, 5, 5, 5));
        this.getContentPane().add(contentPane);
        this.pack();
        this.setSize(640, 480);
        PrereqChecker prereqChecker = PrereqChecker.getInstance();
        prereqChecker.addPrereqCheckerListener(this.prereqCheckerPane);
        prereqChecker.addPrereqCheckerListener(new PrereqCheckerListener(){

            public void update(PrereqCheckerEvent e) {
                PrereqCheckerEvent.Type type = (PrereqCheckerEvent.Type)e.getType();
                switch (type) {
                    case VERIFICATION_STARTED: {
                        detailsPane.setVisible(false);
                        break;
                    }
                    case VERIFICATION_COMPLETED: {
                        detailsPane.setVisible(true);
                        PrereqCheckerFrame.this.prereqCheckerPane.showResults();
                    }
                }
            }
        });
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Application.getInstance().shutdown();
            }
        });
        this.setLocationRelativeTo(null);
    }

    public PrereqCheckerPane getPrereqCheckerPane() {
        return this.prereqCheckerPane;
    }
}

