/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.base.prereq.CompositePrereqCheckerJob;
import oracle.install.commons.base.prereq.PrereqChecker;
import oracle.install.commons.base.prereq.PrereqCheckerErrorCode;
import oracle.install.commons.base.prereq.PrereqCheckerEvent;
import oracle.install.commons.base.prereq.PrereqCheckerException;
import oracle.install.commons.base.prereq.PrereqCheckerJob;
import oracle.install.commons.base.prereq.PrereqCheckerListener;
import oracle.install.commons.swing.ComboBoxAdapter;
import oracle.install.commons.swing.HtmlPane;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.treetable.NodeAccessor;
import oracle.install.commons.swing.treetable.TreeTableColumn;
import oracle.install.commons.swing.treetable.TreeTableModel;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusControl;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobFilter;
import oracle.install.commons.util.progress.JobProgressBar;
import oracle.install.commons.util.progress.JobTreeTable;
import oracle.install.commons.util.progress.ProgressModel;
import oracle.install.commons.util.progress.ProgressModelEvent;
import oracle.install.commons.util.progress.ProgressModelListener;
import oracle.install.commons.util.progress.Status;

public class PrereqCheckerPane
extends JPanel
implements PrereqCheckerListener {
    private static final Logger logger = Logger.getLogger(PrereqCheckerPane.class.getName());
    private static final Object NOTHING = new Object();
    private MultilineLabel lblMessage;
    private MultilineLabel lblResult;
    private JobProgressBar pbrProgress;
    private MultilineLabel lblStatus;
    private JComboBox cbxNodes;
    private JCheckBox chkIgnoreAll;
    private JComboBox cbxStatus;
    private JButton btnRetry;
    private JButton btnFixupRetry;
    private JobTreeTable ttblChecks;
    private CardLayout cardLayout;
    private boolean failedChecksIgnored;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private NodeComboBoxModel nodeComboBoxModel;
    private PrereqCheckerJobFilter jobFilter;
    private HtmlPane detailsPane;
    private DetailsDialog detailsDialog;
    private JPanel detailsPaneContainer;
    private Resource resource;
    private ProgressModel progressModel;
    private MessageBuilder messageBuilder = new MessageBuilder();
    private ViewMode viewMode;

    public PrereqCheckerPane() {
        this.jobFilter = new PrereqCheckerJobFilter();
        Application application = Application.getInstance();
        this.resource = application.getResource("oracle.install.commons.base.prereq.resource.StringResourceBundle");
        this.progressModel = new ProgressModel();
        this.progressModel.addProgressModelListener(new ProgressModelListener(){

            public void update(ProgressModelEvent e) {
                switch ((ProgressModelEvent.Type)e.getType()) {
                    case JOB_STATUS_CHANGED: {
                        Job job = e.getJob();
                        switch (job.getStatus()) {
                            case INPROGRESS: {
                                PrereqCheckerPane.this.lblStatus.setText(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.lblCheckInProgress.text", "Checking {0}", job.getDescription()));
                            }
                        }
                    }
                }
            }
        });
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.add((Component)this.createProgressPane(), "progress");
        this.add((Component)this.createResultPane(), "result");
        this.setViewMode(ViewMode.PROGRESS_MODE);
        this.createDetailsPane();
    }

    private void setViewMode(ViewMode viewMode) {
        if (this.viewMode == viewMode) {
            return;
        }
        this.viewMode = viewMode;
        switch (viewMode) {
            case PROGRESS_MODE: {
                this.cardLayout.show(this, "progress");
                break;
            }
            case RESULT_MODE: {
                this.cardLayout.show(this, "result");
            }
        }
    }

    public DetailsDialog getDetailsDialog() {
        if (this.detailsDialog == null && this.detailsPane != null) {
            this.createDetailsDialog(this.detailsPane);
        }
        return this.detailsDialog;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.detailsDialog != null) {
            this.detailsDialog.dispose();
            this.detailsDialog = null;
        }
    }

    public Component getDetailsPane() {
        return this.detailsPaneContainer;
    }

    private JPanel createProgressPane() {
        this.lblMessage = new MultilineLabel();
        String text = this.resource.getString("prereqCheckerPane.lblMessage.text", "", new Object[0]);
        this.lblMessage.setText(text);
        this.pbrProgress = new JobProgressBar();
        this.pbrProgress.setProgressModel(this.progressModel);
        this.lblStatus = new MultilineLabel();
        JPanel pnlProgress = new JPanel();
        pnlProgress.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.lblMessage, pnlProgress, 0, 0, 1, 1, 2, 17, 1.0, 0.0);
        LayoutUtils.addComponent(this.pbrProgress, pnlProgress, 0, 1, 1, 1, 2, 17, 1.0, 0.0);
        LayoutUtils.addComponent(this.lblStatus, pnlProgress, 0, 2, 1, 1, 2, 17, 1.0, 0.0);
        LayoutUtils.addComponent(Box.createGlue(), pnlProgress, 0, 3, 1, 1, 1, 17, 1.0, 1.0);
        return pnlProgress;
    }

    private void createDetailsPane() {
        this.detailsPane = new HtmlPane();
        this.detailsPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                HyperlinkEvent.EventType eventType = e.getEventType();
                if (eventType == HyperlinkEvent.EventType.ACTIVATED && e.getSource() != null) {
                    PrereqCheckerPane.this.showDetails(null, true);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.detailsPane);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.detailsPaneContainer = new JPanel();
        this.detailsPaneContainer.setBorder(BorderFactory.createEtchedBorder());
        this.detailsPaneContainer.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        LayoutUtils.addComponent(scrollPane, this.detailsPaneContainer, 0, 0, 1, 1, 1, 10, 1.0, 1.0, insets);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                PrereqCheckerPane.this.hideDetails();
            }
        });
    }

    private JPanel createResultPane() {
        this.cbxNodes = new JComboBox();
        char[] prototype = new char[30];
        Arrays.fill(prototype, ' ');
        String prototypeDisplayValue = new String(prototype);
        this.cbxNodes.setPrototypeDisplayValue(prototypeDisplayValue);
        this.cbxNodes.setRenderer(new NodeCellRenderer());
        this.nodeComboBoxModel = new NodeComboBoxModel();
        this.cbxNodes.setModel(this.nodeComboBoxModel);
        this.cbxNodes.setVisible(false);
        String text = this.resource.getString("prereqCheckerPane.cbxNodes.label", "Nodes", new Object[0]);
        JLabel lblForNodesComboxBox = new JLabel(text);
        lblForNodesComboxBox.setLabelFor(this.cbxNodes);
        this.chkIgnoreAll = new JCheckBox();
        text = this.resource.getString("prereqCheckerPane.chkIgnoreAll.text", "Ignore All", new Object[0]);
        SwingUtils.setText(this.chkIgnoreAll, text);
        this.btnRetry = new JButton();
        text = this.resource.getString("prereqCheckerPane.btnRetry.text", "Check Again", new Object[0]);
        SwingUtils.setText(this.btnRetry, text);
        this.btnFixupRetry = new JButton();
        text = this.resource.getString("prereqCheckerPane.btnFixupRetry.text", "&Fix && Check Again", new Object[0]);
        SwingUtils.setText(this.btnFixupRetry, text);
        this.cbxStatus = new JComboBox();
        this.cbxStatus.setRenderer(new StatusListCellRenderer());
        this.cbxStatus.addItem(NOTHING);
        this.cbxStatus.addItem(Status.FAILED);
        this.cbxStatus.addItem(Status.SUCCEEDED);
        text = this.resource.getString("prereqCheckerPane.cbxStatus.label", "Status", new Object[0]);
        JLabel lblForStatusComboxBox = new JLabel("Status");
        lblForStatusComboxBox.setLabelFor(this.cbxStatus);
        this.lblResult = new MultilineLabel();
        text = this.resource.getString("prereqCheckerPane.lblCheckInProgress.text", "", new Object[0]);
        this.lblResult.setText(text);
        this.ttblChecks = new PrereqJobTreeTable(this.progressModel);
        JPanel pnlResult = new JPanel();
        pnlResult.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.lblResult, pnlResult, 0, 0, 6, 1, 2, 10, 1.0, 0.0);
        LayoutUtils.addComponent(this.btnRetry, pnlResult, 0, 1, 1, 1, 0, 17, 0.0, 0.0);
        LayoutUtils.addComponent(this.btnFixupRetry, pnlResult, 1, 1, 1, 1, 0, 17, 0.0, 0.0);
        LayoutUtils.addComponent(this.cbxStatus, pnlResult, 2, 1, 1, 1, 0, 17, 0.0, 0.0);
        LayoutUtils.addComponent(this.cbxNodes, pnlResult, 3, 1, 1, 1, 0, 17, 0.0, 0.0);
        LayoutUtils.addComponent(Box.createGlue(), pnlResult, 4, 1, 1, 1, 2, 17, 1.0, 0.0);
        LayoutUtils.addComponent(this.chkIgnoreAll, pnlResult, 5, 1, 1, 1, 0, 17, 0.0, 0.0);
        JScrollPane scrollPane = new JScrollPane(this.ttblChecks);
        scrollPane.getViewport().setBackground(this.ttblChecks.getBackground());
        LayoutUtils.addComponent(scrollPane, pnlResult, 0, 2, 6, 1, 1, 10, 1.0, 1.0);
        this.btnRetry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PrereqCheckerPane.this.doRetry();
                    }
                });
            }
        });
        this.btnFixupRetry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrereqCheckerPane.this.doFixupRetry();
            }
        });
        ComboBoxAdapter.addItemListener(this.cbxNodes, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object item = e.getItem();
                    PrereqCheckerPane.this.doFilterByNode(item == NOTHING ? null : (String)item);
                }
            }
        });
        this.chkIgnoreAll.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                CompositeJob job = PrereqCheckerPane.this.ttblChecks.getJob();
                if (job != null) {
                    if (selected) {
                        PrereqCheckerPane.this.showFailedChecksOnly();
                        PrereqCheckerPane.this.replaceJobStatus(job, Status.FAILED, Status.IGNORED);
                    } else {
                        PrereqCheckerPane.this.replaceJobStatus(job, Status.IGNORED, Status.FAILED);
                    }
                }
                PrereqCheckerPane.this.setControlPanelEnabled(!selected);
                PrereqCheckerPane.this.setFailedChecksIgnored(selected);
            }
        });
        ComboBoxAdapter.addItemListener(this.cbxStatus, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object item = e.getItem();
                    PrereqCheckerPane.this.showResultsByStatus(item == NOTHING ? null : (Status)((Object)item));
                }
            }
        });
        pnlResult.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                PrereqCheckerPane.this.lblResult.getAccessibleContext().firePropertyChange("AccessibleDescription", "", PrereqCheckerPane.this.lblResult.getText());
            }
        });
        return pnlResult;
    }

    protected void doFilterByNode(String node) {
        if (this.jobFilter.getNode() != node) {
            this.jobFilter.setNode(node);
            this.ttblChecks.filter(this.jobFilter);
            this.ttblChecks.setSelectedNode(this.getFirstDeepestLeaf(this.ttblChecks.getRoot()));
        }
    }

    protected void doFixupRetry() {
        boolean retry = false;
        PrereqChecker prereqChecker = PrereqChecker.getInstance();
        try {
            prereqChecker.fix();
            retry = true;
        }
        catch (PrereqCheckerException e) {
            if (e.getErrorCode() == PrereqCheckerErrorCode.FIXUP_ROUTINES_NOT_AVAILABLE && StandardDialog.promptConfirmation(null, this.resource.getString("prereqCheckerPane.noFixupAvailablePrompt.text", "No automatic fixup routine available. Do you want to perform the checks again ?", new Object[0]))) {
                retry = true;
            }
        }
        catch (Exception e) {
            ExceptionManager.handle(e);
        }
        if (retry) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PrereqCheckerPane.this.doRetry();
                }
            });
        }
    }

    protected void doRetry() {
        this.showProgress();
        this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PrereqChecker prereqChecker = PrereqChecker.getInstance();
                prereqChecker.verify();
                return null;
            }
        });
    }

    private void hideDetails() {
        if (this.detailsDialog != null) {
            this.detailsDialog.setVisible(false);
        }
    }

    protected void showDetails(TreePath prereqPath, final boolean popupDialog) {
        DefaultMutableTreeNode node;
        Object userObject;
        Object component;
        if (prereqPath == null) {
            prereqPath = this.ttblChecks.getTree().getSelectionPath();
        }
        if (prereqPath != null && (component = prereqPath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)component).getUserObject()) != NOTHING && userObject instanceof Job) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String message;
                    DetailsDialog detailsDialog = PrereqCheckerPane.this.getDetailsDialog();
                    if (popupDialog) {
                        detailsDialog.setVisible(true);
                    }
                    if (detailsDialog.isVisible()) {
                        message = PrereqCheckerPane.this.messageBuilder.getDetailedMessage((Job)userObject, PrereqCheckerPane.this.cbxNodes.isVisible());
                        detailsDialog.setDetails(message);
                    }
                    message = PrereqCheckerPane.this.messageBuilder.getShortMessage((Job)userObject);
                    PrereqCheckerPane.this.detailsPane.setText(message);
                    PrereqCheckerPane.this.detailsPane.setCaretPosition(0);
                }
            });
        }
    }

    public void update(PrereqCheckerEvent e) {
        Application application = Application.getInstance();
        StatusControl statusControl = application.getStatusControl();
        PrereqCheckerEvent.Type type = (PrereqCheckerEvent.Type)e.getType();
        final CompositePrereqCheckerJob job = e.getJob();
        final PrereqChecker source = (PrereqChecker)e.getSource();
        switch (type) {
            case NODE_PREPARATION_STARTED: {
                statusControl.open();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String text = PrereqCheckerPane.this.resource.getString("prereqCheckerPane.nodePreparation.started", "Preparing to perform checks...", new Object[0]);
                        PrereqCheckerPane.this.lblStatus.setText(text);
                    }
                });
                break;
            }
            case NODE_PREPARATION_FAILED: 
            case NODE_PREPARATION_FINISHED: {
                statusControl.close();
                break;
            }
            case TASKS_CHANGED: {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String[] nodes = source.getNodes();
                        PrereqCheckerPane.this.nodeComboBoxModel.setNodes(nodes);
                        if (nodes != null && nodes.length > 1) {
                            PrereqCheckerPane.this.cbxNodes.setVisible(true);
                        } else {
                            PrereqCheckerPane.this.cbxNodes.setVisible(false);
                        }
                        PrereqCheckerPane.this.ttblChecks.setJob(job);
                    }
                });
                break;
            }
            case VERIFICATION_STARTED: {
                statusControl.open();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PrereqCheckerPane.this.showProgress();
                        PrereqCheckerPane.this.chkIgnoreAll.setEnabled(true);
                        PrereqCheckerPane.this.chkIgnoreAll.setSelected(false);
                        PrereqCheckerPane.this.hideDetails();
                    }
                });
                break;
            }
            case VERIFICATION_COMPLETED: {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PrereqCheckerPane.this.lblStatus.setText("");
                        boolean success = job.getStatus() == Status.SUCCEEDED;
                        boolean enableFixup = false;
                        if (!success) {
                            PrereqCheckerPane.this.showFailedChecksOnly();
                            if (job instanceof CompositePrereqCheckerJob) {
                                CompositePrereqCheckerJob prereqJob = (CompositePrereqCheckerJob)job;
                                enableFixup = prereqJob.isFixable();
                            }
                        }
                        PrereqCheckerPane.this.btnFixupRetry.setEnabled(enableFixup);
                        PrereqCheckerPane.this.updatePane(success);
                    }
                });
                statusControl.close();
            }
        }
    }

    public boolean isFailedChecksIgnored() {
        return this.failedChecksIgnored;
    }

    public void setFailedChecksIgnored(boolean failedChecksIgnored) {
        if (this.failedChecksIgnored != failedChecksIgnored) {
            boolean oldValue = this.failedChecksIgnored;
            this.failedChecksIgnored = failedChecksIgnored;
            super.firePropertyChange("PrereqCheckerPane.failedChecksIgnored", oldValue, failedChecksIgnored);
        }
    }

    public void showProgress(final boolean reset) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (reset) {
                this.pbrProgress.setValue(0);
            }
            this.setViewMode(ViewMode.PROGRESS_MODE);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PrereqCheckerPane.this.showProgress(reset);
                }
            });
        }
    }

    public void showProgress() {
        this.showProgress(false);
    }

    public void showResults() {
        this.ttblChecks.setSelectedNode(this.getFirstDeepestLeaf(this.ttblChecks.getRoot()));
        this.setViewMode(ViewMode.RESULT_MODE);
    }

    private DefaultMutableTreeNode getFirstDeepestLeaf(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode leafNode = node;
        if (node != null && !node.isLeaf()) {
            Enumeration<TreeNode> e = node.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)e.nextElement();
                if (!treeNode.isLeaf()) continue;
                leafNode = treeNode;
                break;
            }
        }
        return leafNode;
    }

    private void showResultsByStatus(Status status) {
        if (status == null || status != this.jobFilter.getStatus()) {
            this.detailsPane.setText("");
            this.jobFilter.setStatus(status);
            this.ttblChecks.filter(this.jobFilter);
            this.showResults();
        }
    }

    public void showSucceededChecksOnly() {
        this.setViewMode(ViewMode.RESULT_MODE);
        this.jobFilter.reset();
        this.cbxStatus.setSelectedItem((Object)Status.SUCCEEDED);
        this.cbxNodes.setSelectedItem(NOTHING);
        this.showResultsByStatus(Status.SUCCEEDED);
    }

    public void showAllChecks() {
        this.setViewMode(ViewMode.RESULT_MODE);
        this.jobFilter.reset();
        this.cbxStatus.setSelectedItem(NOTHING);
        this.cbxNodes.setSelectedItem(NOTHING);
        this.showResultsByStatus(null);
    }

    public void showFailedChecksOnly() {
        this.setViewMode(ViewMode.RESULT_MODE);
        this.jobFilter.reset();
        this.cbxStatus.setSelectedItem((Object)Status.FAILED);
        this.cbxNodes.setSelectedItem(NOTHING);
        this.showResultsByStatus(Status.FAILED);
    }

    private void updatePane(boolean success) {
        String text = this.resource.getString(success ? "prereqCheckerPane.success.message" : "prereqCheckerPane.error.message", "", new Object[0]);
        this.lblResult.setText(text);
        this.chkIgnoreAll.setEnabled(!success);
    }

    protected void setControlPanelEnabled(boolean enabled) {
        this.btnRetry.setEnabled(enabled);
        this.cbxStatus.setEnabled(enabled);
        this.cbxNodes.setEnabled(enabled);
        this.btnFixupRetry.setEnabled(enabled);
    }

    private void replaceJobStatus(Job job, Status oldStatus, Status newStatus) {
        CompositeJob compositeJob;
        List<Job> jobs;
        Status status = job.getStatus();
        if (status == oldStatus) {
            job.setStatus(newStatus);
        }
        if (job instanceof CompositeJob && (jobs = (compositeJob = (CompositeJob)job).getJobs()) != null) {
            for (Job j : jobs) {
                this.replaceJobStatus(j, oldStatus, newStatus);
            }
        }
    }

    private void createDetailsDialog(Component component) {
        if (this.detailsDialog == null) {
            Window window = SwingUtilities.windowForComponent(component);
            this.detailsDialog = window instanceof Frame ? new DetailsDialog((Frame)window) : (window instanceof Dialog ? new DetailsDialog((Dialog)window) : new DetailsDialog((Frame)null));
            this.detailsDialog.setTitle(this.resource.getString("prereqCheckerPane.detailsDialog.title", "Details", new Object[0]));
        }
    }

    protected class PrereqJobTreeTable
    extends JobTreeTable {
        private boolean filtering;

        public PrereqJobTreeTable(ProgressModel progressModel) {
            super(null, progressModel, new TreeTableColumn[]{new TreeTableColumn(" ", Status.class), new TreeTableColumn(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.ttblChecks.column.checks.text", "Checks", new Object[0]), TreeTableModel.class), new TreeTableColumn(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.ttblChecks.column.status.text", "Status", new Object[0]), Status.class), new TreeTableColumn(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.ttblChecks.column.fix.text", "Fixable", new Object[0]), String.class)}, new PrereqJobTreeNodeAccessor());
            this.setCompositeJobStatusVisible(false);
            this.getColumnModel().getColumn(3).setMaxWidth(50);
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(32, 0, true), "showMoreDetails");
            ActionMap actionMap = this.getActionMap();
            actionMap.put("showMoreDetails", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    PrereqCheckerPane.this.showDetails(null, true);
                }
            });
            this.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    if (PrereqJobTreeTable.this.filtering) {
                        return;
                    }
                    PrereqCheckerPane.this.showDetails(e.getNewLeadSelectionPath(), false);
                }
            });
        }

        public void filter(JobFilter jobFilter) {
            this.filtering = true;
            super.filter(jobFilter);
            this.filtering = false;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePrereqJobTreeTable();
            }
            return this.accessibleContext;
        }

        protected class AccessiblePrereqJobTreeTable
        extends JTable.AccessibleJTable
        implements TreeSelectionListener {
            public AccessiblePrereqJobTreeTable() {
                super(PrereqJobTreeTable.this);
                JTree tree = PrereqJobTreeTable.this.getTree();
                tree.addTreeSelectionListener(this);
            }

            public void valueChanged(TreeSelectionEvent e) {
                if (PrereqJobTreeTable.this.filtering) {
                    return;
                }
                TreePath treePath = e.getNewLeadSelectionPath();
                if (treePath != null) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    Object userObject = treeNode.getUserObject();
                    String description = null;
                    if (userObject instanceof Job) {
                        Job job = (Job)userObject;
                        description = job.getDescription();
                        Status status = job.getStatus();
                        String fixupAvailable = "";
                        String tip = "";
                        boolean fixable = false;
                        if (status != Status.SUCCEEDED && userObject instanceof PrereqCheckerJob) {
                            fixable = ((PrereqCheckerJob)userObject).isFixable();
                            String string = fixupAvailable = fixable ? PrereqCheckerPane.this.resource.getString("prereqCheckerPane.PrereqJobTreeTable.AccessiblePrereqJobTreeTable.fixupAvailable", "Fixup routine available", new Object[0]) : PrereqCheckerPane.this.resource.getString("prereqCheckerPane.PrereqJobTreeTable.AccessiblePrereqJobTreeTable.fixupNotAvailable", "Fixup routine not available", new Object[0]);
                        }
                        if (userObject instanceof PrereqCheckerJob) {
                            tip = PrereqCheckerPane.this.resource.getString("prereqCheckerPane.PrereqJobTreeTable.AccessiblePrereqJobTreeTable.tip", "Press SPACEBAR to view more details", new Object[0]);
                        }
                        description = String.format("%s. %s. %s. %s", new Object[]{description, status, fixupAvailable, tip});
                    } else if (userObject != null) {
                        description = userObject.toString();
                    }
                    if (description != null) {
                        this.setAccessibleDescription(description);
                    }
                }
            }

            public void valueChanged(ListSelectionEvent e) {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MessageBuilder {
        private StringBuffer messageBuffer = new StringBuffer();

        MessageBuilder() {
        }

        public String getShortMessage(Job job) {
            return this.getMessage(job, true);
        }

        public String getDetailedMessage(Job job, boolean multiNode) {
            return this.getMessage(job, false);
        }

        private String getMessage(Job job, boolean shortMessage) {
            Job j;
            this.messageBuffer.setLength(0);
            VerificationTask task = null;
            VerificationResultSet resultSet = null;
            if (job instanceof CompositePrereqCheckerJob) {
                j = (CompositePrereqCheckerJob)job;
                task = ((CompositePrereqCheckerJob)j).getVerificationTask();
                resultSet = ((CompositePrereqCheckerJob)j).getVerificationResultSet();
            } else if (job instanceof PrereqCheckerJob) {
                j = (PrereqCheckerJob)job;
                task = ((PrereqCheckerJob)j).getVerificationTask();
                resultSet = ((PrereqCheckerJob)j).getVerificationResultSet();
            }
            this.updateMessageBuffer(this.messageBuffer, task, shortMessage);
            String node = null;
            boolean multiNodeSummary = false;
            if (PrereqCheckerPane.this.cbxNodes.isVisible()) {
                Object selectedItem = PrereqCheckerPane.this.cbxNodes.getSelectedItem();
                node = selectedItem == NOTHING ? null : (String)selectedItem;
                multiNodeSummary = node == null;
            }
            try {
                this.updateMessageBuffer(this.messageBuffer, resultSet, node, shortMessage, multiNodeSummary);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error occured while building verification result summary", e);
            }
            return this.messageBuffer.toString();
        }

        private void updateMessageBuffer(StringBuffer messageBuffer, VerificationTask task, boolean shortMessage) {
            if (task != null) {
                String desc;
                if (!shortMessage) {
                    messageBuffer.append(task.getElementName()).append(" - ");
                }
                messageBuffer.append((desc = task.getDescription()) != null ? desc : (!shortMessage ? PrereqCheckerPane.this.resource.getString("prereqCheckerPane.details.emptyValue", "n/a", new Object[0]) : ""));
                if (shortMessage) {
                    messageBuffer.append("&nbsp;<a href=\"#\">").append(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.lnkMoreDetails.text", "details", new Object[0])).append("</a>");
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void updateMessageBuffer(StringBuffer messageBuffer, VerificationResultSet resultSet, String node, boolean shortMessage, boolean multiNodeSummary) throws Exception {
            if (resultSet == null) {
                return;
            }
            if (multiNodeSummary) {
                this.updateMessageBuffer(messageBuffer, resultSet, shortMessage);
                if (shortMessage) return;
                OverallStatus overallStatus = resultSet.getOverallStatus();
                switch (overallStatus) {
                    case OPERATION_FAILED: 
                    case VERIFICATION_FAILED: {
                        List failedNodeList = resultSet.getFailedNodes();
                        if (failedNodeList == null || failedNodeList.isEmpty()) return;
                        messageBuffer.append("<br></br>");
                        for (String failedNode : failedNodeList) {
                            VerificationResult result = resultSet.getNodeResult(failedNode);
                            if (result == null) continue;
                            messageBuffer.append("<a name=\"" + failedNode + "\"></a>");
                            messageBuffer.append(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.details.failedNodeResult", "Verification result of failed node: {0}", failedNode));
                            messageBuffer.append("<br></br>");
                            this.updateMessageBuffer(messageBuffer, result, shortMessage);
                            messageBuffer.append("<a href=\"#top\">" + PrereqCheckerPane.this.resource.getString("prereqCheckerPane.details.backToTop.text", "Back to Top", new Object[0]) + "</a>");
                            messageBuffer.append("<br></br>");
                            messageBuffer.append("<br></br>");
                        }
                        return;
                    }
                    case SUCCESSFUL: 
                    case WARNING: {
                        List succeededNodeList = resultSet.getSuccessfulNodes();
                        if (succeededNodeList == null || succeededNodeList.isEmpty()) return;
                        messageBuffer.append("<br></br><br></br>");
                        for (String succeededNode : succeededNodeList) {
                            VerificationResult result = resultSet.getNodeResult(succeededNode);
                            if (result == null) continue;
                            messageBuffer.append("<a name=\"" + succeededNode + "\"></a>");
                            messageBuffer.append(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.details.succeededNodeResult", "Verification result of succeeded node: {0}", succeededNode));
                            messageBuffer.append("<br></br>");
                            this.updateMessageBuffer(messageBuffer, result, shortMessage);
                            messageBuffer.append("<br></br>");
                        }
                        return;
                    }
                }
                return;
            }
            VerificationResult result = null;
            if (node == null) {
                List nodeResults;
                if (resultSet.hasNodeResults() && (nodeResults = resultSet.getNodeResults()) != null && !nodeResults.isEmpty()) {
                    result = (VerificationResult)nodeResults.get(0);
                }
            } else {
                result = resultSet.getNodeResult(node);
            }
            this.updateMessageBuffer(messageBuffer, result, shortMessage);
        }

        private void updateMessageBuffer(StringBuffer messageBuffer, VerificationResult result, boolean shortMessage) throws Exception {
            if (result != null) {
                String emptyValue;
                String expectedValue = emptyValue = PrereqCheckerPane.this.resource.getString("prereqCheckerPane.details.emptyValue", "n/a", new Object[0]);
                try {
                    if (result.hasResultValues()) {
                        expectedValue = result.getExpectedValue();
                    } else {
                        logger.log(Level.INFO, "Expected value not found.");
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Expected value not found. Exception: ", e);
                }
                messageBuffer.append("<table cellspacing=\"1\" cellpadding=\"1\">");
                expectedValue = expectedValue != null ? expectedValue : emptyValue;
                messageBuffer.append("<tr><td align=\"left\" nowrap>").append(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.details.expectedValue", "Expected Value", new Object[0])).append("</td><td>&nbsp;:&nbsp;").append(expectedValue).append("</td></tr>");
                String actualValue = emptyValue;
                try {
                    if (result.hasResultValues()) {
                        actualValue = result.getActualValue();
                    } else {
                        logger.log(Level.INFO, "Actual value not found.");
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Actual value not found. Exception: ", e);
                }
                actualValue = actualValue != null ? actualValue : emptyValue;
                messageBuffer.append("<tr><td align=\"left\" nowrap>").append(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.details.actualValue", "Actual Value", new Object[0])).append("</td><td>&nbsp;:&nbsp;").append(actualValue).append("</td></tr>");
                messageBuffer.append("</table>");
                if (!shortMessage) {
                    this.updateMessageBuffer(messageBuffer, result.getErrors());
                }
            }
        }

        private String getNodeList(List<String> nodeList) {
            int n = nodeList.size();
            StringBuffer buffer = new StringBuffer();
            buffer.append("[");
            for (int i = 0; i < n; ++i) {
                String node = nodeList.get(i);
                buffer.append("<a href=\"#").append(node).append("\">").append(node).append("</a>");
                if (i + 1 == n) continue;
                buffer.append(", &nbsp;");
            }
            buffer.append("]");
            return buffer.toString();
        }

        private void updateMessageBuffer(StringBuffer messageBuffer, VerificationResultSet resultSet, boolean shortMessage) {
            if (resultSet != null) {
                List nodeList = null;
                messageBuffer.append("<a name=\"top\"></a>");
                switch (resultSet.getOverallStatus()) {
                    case OPERATION_FAILED: {
                        nodeList = resultSet.getFailedNodes();
                        if (nodeList == null || nodeList.size() <= 0) break;
                        messageBuffer.append("<br></br><br></br>");
                        messageBuffer.append(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.details.operationFailedOnNodes", "Operation Failed On Nodes: {0}", shortMessage ? nodeList.toString() : this.getNodeList(nodeList)));
                        messageBuffer.append("<br></br>");
                        break;
                    }
                    case VERIFICATION_FAILED: {
                        nodeList = resultSet.getFailedNodes();
                        if (nodeList != null && nodeList.size() > 0) {
                            messageBuffer.append("<br></br><br></br>");
                            messageBuffer.append(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.details.failedNodes", "Check Failed On Nodes: {0}", shortMessage ? nodeList.toString() : this.getNodeList(nodeList)));
                            messageBuffer.append("<br></br>");
                        }
                        if ((nodeList = resultSet.getSuccessfulNodes()) == null || nodeList.size() <= 0) break;
                        messageBuffer.append(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.details.successfulNodes", "Check Succeeded On Nodes: {0}", nodeList.toString()));
                        messageBuffer.append("<br></br>");
                    }
                }
                if (!shortMessage) {
                    this.updateMessageBuffer(messageBuffer, resultSet.getErrors());
                }
            }
        }

        private void updateMessageBuffer(StringBuffer messageBuffer, List<VerificationError> errors) {
            if (errors != null && !errors.isEmpty()) {
                messageBuffer.append("&nbsp;").append(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.details.errorList", "List of errors", new Object[0])).append("<br></br>").append("<table border=\"0\">");
                for (VerificationError error : errors) {
                    String message = error.getErrorMessage();
                    String cause = error.getCause();
                    String action = error.getAction();
                    if (message == null) continue;
                    messageBuffer.append("<tr>");
                    messageBuffer.append("<td valign=\"top\" align=\"left\" nowrap>").append("&nbsp;-&nbsp;").append("</td>");
                    messageBuffer.append("<td>").append(message).append("<br></br>");
                    if (cause != null) {
                        messageBuffer.append("&nbsp;- Cause:&nbsp;").append(error.getCause()).append("<br></br>");
                    }
                    if (action != null) {
                        messageBuffer.append("&nbsp;- Action:&nbsp;").append(error.getAction()).append("<br></br>");
                    }
                    messageBuffer.append("</td>");
                    messageBuffer.append("</tr>");
                }
                messageBuffer.append("</table>");
            }
        }
    }

    class DetailsDialog
    extends JDialog {
        private HtmlPane txaMessage;

        private DetailsDialog(Frame parent) {
            super(parent);
            this.init(parent);
        }

        private DetailsDialog(Dialog parent) {
            super(parent);
            this.init(parent);
        }

        private void init(Window parent) {
            this.txaMessage = new HtmlPane();
            this.txaMessage.setEditable(false);
            this.txaMessage.setOpaque(false);
            this.setSize(new Dimension(400, 300));
            Point location = parent.getLocation();
            Dimension parentSize = parent.getSize();
            Dimension size = this.getSize();
            location.x += parentSize.width / 2 - size.width / 2;
            location.y += parentSize.height / 2 - size.height / 2;
            this.setLocation(location);
            this.setAlwaysOnTop(true);
            this.setLayout(new BorderLayout());
            this.add(new JScrollPane(this.txaMessage));
            JButton btnClose = new JButton();
            btnClose.setName("PrereqCheckerPane.DetailsDialog.btnClose");
            btnClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DetailsDialog.this.doClose();
                }
            });
            btnClose.setText(PrereqCheckerPane.this.resource.getString("prereqCheckerFrame.btnClose.text", "Close", new Object[0]));
            JPanel space = new JPanel();
            space.setLayout(new BorderLayout());
            space.add((Component)btnClose, "East");
            this.add((Component)space, "Last");
        }

        public void setDetails(String message) {
            this.txaMessage.setText(message);
            this.txaMessage.setCaretPosition(0);
        }

        private void doClose() {
            this.setVisible(false);
        }
    }

    private class PrereqCheckerJobFilter
    implements JobFilter {
        private String node;
        private Status status;

        public void reset() {
            this.node = null;
            this.status = null;
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public boolean accept(Job job) {
            boolean accept = false;
            if (this.status == null || job instanceof CompositeJob) {
                accept = true;
            } else if (job instanceof PrereqCheckerJob) {
                PrereqCheckerJob prereqCheckerJob = (PrereqCheckerJob)job;
                VerificationResultSet resultSet = prereqCheckerJob.getVerificationResultSet();
                if (this.node != null) {
                    List nodes;
                    List list = nodes = this.status == Status.FAILED ? resultSet.getFailedNodes() : resultSet.getSuccessfulNodes();
                    if (nodes != null) {
                        accept = nodes.contains(this.node);
                    }
                } else {
                    accept = this.status == prereqCheckerJob.getStatus();
                }
            }
            return accept;
        }
    }

    private class NodeComboBoxModel
    extends DefaultComboBoxModel {
        public void setNodes(String[] nodes) {
            this.removeAllElements();
            if (nodes != null) {
                if (nodes.length > 1) {
                    this.addElement(NOTHING);
                }
                for (String node : nodes) {
                    this.addElement(node);
                }
            }
        }
    }

    private class StatusListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = null;
            text = value == Status.SUCCEEDED ? PrereqCheckerPane.this.resource.getString("prereqCheckerPane.cbxStatus.item.succeeded.text", "Show Succeeded", new Object[0]) : (value == Status.FAILED ? PrereqCheckerPane.this.resource.getString("prereqCheckerPane.cbxStatus.item.failed.text", "Show Failed", new Object[0]) : PrereqCheckerPane.this.resource.getString("prereqCheckerPane.cbxStatus.item.all.text", "Show All", new Object[0]));
            this.setText(text);
            return component;
        }
    }

    private class NodeCellRenderer
    extends DefaultListCellRenderer {
        private Icon icon;

        public NodeCellRenderer() {
            URL iconUrl = this.getClass().getResource("/oracle/install/commons/base/prereq/resource/image/host_ena.png");
            this.icon = new ImageIcon(iconUrl);
            this.setIcon(this.icon);
            this.setIconTextGap(5);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(this.icon);
            if (value == NOTHING) {
                this.setText(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.allNodes.text", "All Nodes", new Object[0]));
            } else {
                this.setText((String)value);
            }
            return component;
        }
    }

    private class PrereqJobTreeNodeAccessor
    implements NodeAccessor {
        public Object getValueAt(Object node, int column) {
            DefaultMutableTreeNode n;
            Job job;
            Object value = null;
            if (node instanceof DefaultMutableTreeNode && (job = (Job)(n = (DefaultMutableTreeNode)node).getUserObject()) != null) {
                switch (column) {
                    case 0: {
                        Status status;
                        if (n.isRoot() && n.getParent() == null || (status = job.getStatus()) != Status.INPROGRESS) break;
                        value = status;
                        break;
                    }
                    case 1: {
                        value = job;
                        break;
                    }
                    case 2: {
                        if (n.isRoot() && n.getParent() == null) break;
                        if (PrereqCheckerPane.this.jobFilter != null) {
                            if (job instanceof PrereqCheckerJob) {
                                PrereqCheckerJob prereqCheckerJob = (PrereqCheckerJob)job;
                                value = prereqCheckerJob.getStatus(PrereqCheckerPane.this.jobFilter.getNode());
                            } else if (job instanceof CompositePrereqCheckerJob) {
                                CompositePrereqCheckerJob prereqCheckerJob = (CompositePrereqCheckerJob)job;
                                value = prereqCheckerJob.getStatus(PrereqCheckerPane.this.jobFilter.getNode());
                            }
                        }
                        if (value != null) break;
                        value = job.getStatus();
                        break;
                    }
                    case 3: {
                        if (n.isRoot() && n.getParent() == null || !(job instanceof PrereqCheckerJob)) break;
                        boolean fixable = false;
                        PrereqCheckerJob prereqCheckerJob = (PrereqCheckerJob)job;
                        fixable = PrereqCheckerPane.this.jobFilter != null && PrereqCheckerPane.this.jobFilter.getNode() != null ? prereqCheckerJob.isFixable(PrereqCheckerPane.this.jobFilter.getNode()) : prereqCheckerJob.isFixable();
                        if (!fixable) break;
                        value = PrereqCheckerPane.this.resource.getString("prereqCheckerPane.yes", "Yes", new Object[0]);
                    }
                }
            }
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ViewMode {
        PROGRESS_MODE,
        RESULT_MODE;

    }
}

