/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.summary;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.install.commons.base.resource.StringResourceBundle;
import oracle.install.commons.base.summary.Category;
import oracle.install.commons.base.summary.ComponentSet;
import oracle.install.commons.base.summary.Percentage;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.base.summary.Variable;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.XmlBeanStoreFileChooser;
import oracle.install.commons.swing.tree.TreeUtils;
import oracle.install.commons.system.filemgmt.FileSystemErrorCode;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

public class SummaryPane
extends JPanel {
    private JButton btnSave;
    private JFileChooser chooser;
    private Resource resource;
    private JTree tree;
    private SummaryTreeModel treeModel;
    private PropertyChangeListener summaryPropertyListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            SummaryPane.this.treeModel.reloadTree();
        }
    };

    public SummaryPane() {
        Application application = Application.getInstance();
        this.resource = application.getResource(StringResourceBundle.class.getName());
        this.buildUI();
        this.localize();
    }

    public Summary getSummary() {
        return this.treeModel.getSummary();
    }

    public void setSummary(Summary setupSummary) {
        this.treeModel.setSummary(setupSummary);
    }

    public void addSaveActionListener(ActionListener listener) {
        this.btnSave.addActionListener(listener);
    }

    public void removeSaveActionListener(ActionListener listener) {
        this.btnSave.removeActionListener(listener);
    }

    protected void buildUI() {
        this.btnSave = new JButton();
        this.btnSave.setName("SummaryPane.btnSave");
        this.chooser = new XmlBeanStoreFileChooser();
        this.setLayout(new GridBagLayout());
        this.tree = new JTree();
        this.treeModel = new SummaryTreeModel();
        this.tree.setLargeModel(true);
        this.tree.setModel(this.treeModel);
        this.tree.setCellRenderer(new SummaryTreeCellRenderer(null));
        this.tree.setRootVisible(false);
        this.tree.setRowHeight(Math.round(1.2f * (float)this.tree.getRowHeight()));
        this.tree.setShowsRootHandles(true);
        this.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(this.tree);
        LayoutUtils.addComponent(scrollPane, this, 0, 0, 1, 1, 1, 10, 1.0, 1.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.btnSave, this, 0, 1, 1, 1, 0, 13, 0.0, 0.0, new Insets(5, 5, 5, 5));
    }

    public void localize() {
        SwingUtils.setText(this.btnSave, this.resource.getString("SummaryPane.btnSave.text", "&Save Response File...", new Object[0]));
        this.chooser.setDialogTitle(this.resource.getString("SummaryPane.SaveDialog.title", "Save Response File", new Object[0]));
    }

    public File getResponseFile() {
        int returnVal;
        String rspName;
        File responseFile = null;
        Frame parent = (Frame)SwingUtilities.windowForComponent(this);
        Application application = Application.getInstance();
        if (this.chooser.getSelectedFile() == null && (rspName = application.getString("SummaryPane.responseFile.name", null, new Object[0])) != null) {
            this.chooser.setSelectedFile(new File(rspName));
        }
        if ((returnVal = this.chooser.showSaveDialog(parent)) == 0) {
            responseFile = this.chooser.getSelectedFile();
            File ParentDir = new File(responseFile.getParent());
            if (!ParentDir.canWrite()) {
                StandardDialog.showError(null, FileSystemErrorCode.TARGET_DIR_NOT_WRITABLE, ParentDir);
                responseFile = null;
            } else if (responseFile.exists()) {
                String title = this.chooser.getDialogTitle();
                String message = this.resource.getString("SummaryPane.fileReplaceConfirmation.text", "{0} already exists.\nDo you want to replace it ?", responseFile.getPath());
                int result = JOptionPane.showConfirmDialog(parent, message, title, 0, 2);
                if (result != 0) {
                    responseFile = null;
                }
            }
        }
        return responseFile;
    }

    private class SummaryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        Font plainFont;
        Font boldFont;
        Icon icon;

        public SummaryTreeCellRenderer(Icon icon) {
            this.icon = icon;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObject = node.getUserObject();
                String newValue = null;
                if (userObject instanceof Summary) {
                    newValue = ((Summary)userObject).getDescription();
                } else if (userObject instanceof Category) {
                    newValue = ((Category)userObject).getDescription();
                } else if (userObject instanceof Variable) {
                    String description = ((Variable)userObject).getDescription();
                    Object obj = ((Variable)userObject).getValue();
                    if (obj != null) {
                        if (obj instanceof Percentage) {
                            Percentage percentage = (Percentage)obj;
                            String message = percentage.getDescription();
                            if (message == null) {
                                message = String.valueOf(percentage.getPercentage());
                            }
                            newValue = description + ": " + message;
                        } else {
                            newValue = description + ": " + obj;
                        }
                    } else {
                        newValue = description + ": " + SummaryPane.this.resource.getString("SummaryPane.notSpecified", "<Not Specified>", new Object[0]);
                    }
                } else if (userObject instanceof ComponentSet) {
                    newValue = ((ComponentSet)userObject).getDescription();
                } else if (userObject instanceof oracle.install.commons.base.interview.common.bean.Component) {
                    oracle.install.commons.base.interview.common.bean.Component component = (oracle.install.commons.base.interview.common.bean.Component)userObject;
                    newValue = component.getName() + ": " + component.getVersion();
                }
                if (newValue != null) {
                    value = newValue;
                }
            }
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(this.icon);
            Font font = this.getFont();
            if (!leaf) {
                if (this.boldFont == null) {
                    this.boldFont = new Font(font.getFamily(), 1, font.getSize());
                }
                this.setFont(this.boldFont);
            } else {
                if (this.plainFont == null) {
                    this.plainFont = new Font(font.getFamily(), 0, font.getSize());
                }
                this.setFont(this.plainFont);
            }
            return this;
        }
    }

    private class SummaryTreeModel
    extends DefaultTreeModel {
        private Summary summary;

        public SummaryTreeModel() {
            super(new DefaultMutableTreeNode(""), false);
        }

        public Summary getSummary() {
            return this.summary;
        }

        public void setSummary(Summary summary) {
            if (this.summary != summary) {
                this.summary = summary;
                this.summary.addPropertyChangeListener("Summary.ready", SummaryPane.this.summaryPropertyListener);
                this.reloadTree();
            }
        }

        public void reloadTree() {
            if (this.summary != null && this.summary.isReady()) {
                this.reset();
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)SummaryPane.this.treeModel.getRoot();
                Category category2 = null;
                ComponentSet componentSet2 = null;
                try {
                    DefaultMutableTreeNode summaryNode = new DefaultMutableTreeNode(this.summary);
                    this.addNode(root, summaryNode);
                    for (Category category2 : this.summary.getCategories()) {
                        DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(category2);
                        this.addNode(summaryNode, categoryNode);
                        for (Variable variable : category2.getVariables()) {
                            DefaultMutableTreeNode variableNode = new DefaultMutableTreeNode(variable);
                            this.addNode(categoryNode, variableNode);
                        }
                    }
                    for (ComponentSet componentSet2 : this.summary.getComponentSets()) {
                        DefaultMutableTreeNode componentSetNode = new DefaultMutableTreeNode(componentSet2);
                        this.addNode(summaryNode, componentSetNode);
                        for (oracle.install.commons.base.interview.common.bean.Component component : componentSet2.getComponents()) {
                            DefaultMutableTreeNode componentNode = new DefaultMutableTreeNode(component);
                            this.addNode(componentSetNode, componentNode);
                        }
                    }
                    TreeUtils.setSubTreeExpanded(SummaryPane.this.tree, root, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void reset() {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
            Enumeration<TreeNode> nodeList = root.postorderEnumeration();
            while (nodeList.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeList.nextElement();
                if (node.isLeaf() || node.getChildCount() <= 0) continue;
                int[] childIndices = new int[node.getChildCount()];
                Object[] children = new Object[node.getChildCount()];
                for (int i = 0; i < childIndices.length; ++i) {
                    children[i] = node.getChildAt(i);
                    childIndices[i] = i;
                }
                Object[] path = node.getPath();
                node.removeAllChildren();
                this.fireTreeNodesRemoved(this, path, childIndices, children);
            }
        }

        public void addNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode node) throws Exception {
            parent.add(node);
            int[] childIndices = new int[]{parent.getIndex(node)};
            Object[] path = parent.getPath();
            Object[] children = new Object[]{node};
            this.fireTreeNodesInserted(this, path, childIndices, children);
            this.nodeChanged(node);
        }
    }
}

