/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.install.commons.base.util.InstallComponent;
import oracle.install.commons.bean.annotation.BeanDef;
import oracle.install.commons.bean.annotation.PropertyDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BeanDef(value="component-config", beanStore=true)
public class ComponentConfig
implements Comparable {
    private String name;
    private String description;
    private List<InstallComponent> components;

    public ComponentConfig() {
        this(null, null);
    }

    public ComponentConfig(String name, String description) {
        this.description = description;
        this.name = name;
        this.components = new ArrayList<InstallComponent>();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addComponent(InstallComponent component) {
        this.components.add(component);
    }

    public InstallComponent getComponentByName(String name) {
        for (InstallComponent component : this.components) {
            if (!component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }

    public InstallComponent getComponentByID(String id) {
        for (InstallComponent component : this.components) {
            if (!component.getId().equals(id)) continue;
            return component;
        }
        return null;
    }

    @PropertyDef(value="components")
    public List<InstallComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<InstallComponent> components) {
        this.components = components;
    }

    public List<InstallComponent> getVisibleComponents() {
        ArrayList<InstallComponent> lstVisibleComps = new ArrayList<InstallComponent>();
        for (InstallComponent component : this.components) {
            if (!component.isVisible()) continue;
            lstVisibleComps.add(component);
        }
        return lstVisibleComps;
    }

    public List<InstallComponent> getSelectedComponents() {
        ArrayList<InstallComponent> lstSelectedComps = new ArrayList<InstallComponent>();
        for (InstallComponent component : this.components) {
            if (!component.isSelectedForInstall()) continue;
            lstSelectedComps.add(component);
        }
        return lstSelectedComps;
    }

    public String[] getSelectedVisibleComponents() {
        ArrayList<String> lstSelectedComps = new ArrayList<String>();
        for (InstallComponent component : this.components) {
            if (!component.isSelectedForInstall()) continue;
            lstSelectedComps.add(component.toString());
        }
        return lstSelectedComps.toArray(new String[0]);
    }

    public void setSelectedVisibleComponents(String[] selectedComponents) {
        if (selectedComponents != null && selectedComponents.length > 0) {
            List<String> list = Arrays.asList(selectedComponents);
            ArrayList<String> namelist = new ArrayList<String>();
            for (String id : list) {
                namelist.add(id.substring(0, id.indexOf(":")));
            }
            for (InstallComponent component : this.components) {
                component.setSelectedForInstall(namelist.contains(component.getName()));
            }
        }
    }

    public boolean areComponentsSelected(String[] components) {
        String[] selectedComponents;
        boolean selected = false;
        if (components != null && (selectedComponents = this.getSelectedVisibleComponents()) != null) {
            selected = Arrays.asList(selectedComponents).containsAll(Arrays.asList(components));
        }
        return selected;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : super.hashCode();
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int compareTo(Object o) {
        int ret = 1;
        if (o != null) {
            ComponentConfig set = (ComponentConfig)o;
            InstallComponent component1 = null;
            InstallComponent component2 = null;
            Iterator<InstallComponent> iterator = this.components.iterator();
            if (this.components.size() == set.getComponents().size()) {
                while (iterator.hasNext() && (ret = (component1 = iterator.next()).compareTo(component2 = set.getComponentByID(component1.getId()))) == 0) {
                    if (!(component1.isSelectedForInstall() ^ component2.isSelectedForInstall())) continue;
                    ret = 1;
                    break;
                }
            }
        }
        return ret;
    }
}

