/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import oracle.install.commons.base.util.ComponentConfig;
import oracle.install.commons.base.util.ComponentConfigSource;
import oracle.install.commons.base.util.InstallComponent;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentConfigBuilder {
    private static final Logger logger = Logger.getLogger(ComponentConfigBuilder.class.getName());
    private Map<ComponentConfigSource, ComponentConfig> beanMap = new HashMap<ComponentConfigSource, ComponentConfig>();
    private static ComponentConfigBuilder instance;

    public static ComponentConfigBuilder getInstance() {
        if (instance == null) {
            instance = new ComponentConfigBuilder();
        }
        return instance;
    }

    private ComponentConfigBuilder() {
    }

    public ComponentConfig getComponentBean(URL configFile) throws Exception {
        return this.getComponentBean(configFile, false);
    }

    public ComponentConfig getComponentBean(URL configFile, boolean reload) throws Exception {
        ComponentConfigSource source = new ComponentConfigSource(configFile);
        ComponentConfig bean = this.getComponentBean(source, reload);
        return bean;
    }

    public ComponentConfig getComponentBean(ComponentConfigSource source) throws Exception {
        return this.getComponentBean(source, false);
    }

    public ComponentConfig getComponentBean(ComponentConfigSource source, boolean reload) throws Exception {
        ComponentConfig bean = this.beanMap.get(source);
        if (bean == null || reload) {
            logger.info("Re-loading component config bean");
            bean = BeanStoreUtils.restoreFromXML(source, ComponentConfig.class);
            this.buildDependencyList(bean);
            this.beanMap.put(source, bean);
        }
        return bean;
    }

    public ComponentConfig buildComponentBean(URL configURL) throws Exception {
        ComponentConfigSource source = new ComponentConfigSource(configURL);
        ComponentConfig bean = this.buildComponentBean(source);
        return bean;
    }

    public ComponentConfig buildComponentBean(ComponentConfigSource source) throws Exception {
        ComponentConfig bean = BeanStoreUtils.restoreFromXML(source, ComponentConfig.class);
        this.buildDependencyList(bean);
        return bean;
    }

    private void buildDependencyList(ComponentConfig bean) {
        logger.info("Resolving dependencies");
        if (bean != null) {
            TreeMap<String, InstallComponent> compMap = new TreeMap<String, InstallComponent>();
            for (InstallComponent comp : bean.getComponents()) {
                compMap.put(comp.getId(), comp);
            }
            for (InstallComponent comp : bean.getComponents()) {
                ArrayList<InstallComponent> depList = new ArrayList<InstallComponent>();
                for (String dependentId : comp.getDependants()) {
                    InstallComponent dependent = (InstallComponent)compMap.get(dependentId);
                    if (dependent == null) continue;
                    depList.add(dependent);
                }
                comp.setDependentComponents(depList);
            }
        }
    }

    public Map<String, String[]> buildOUIDependencyMap(ComponentConfig bean) {
        TreeMap<String, String[]> map = new TreeMap<String, String[]>();
        for (InstallComponent comp : bean.getComponents()) {
            if (!comp.isSelectedForInstall()) continue;
            ArrayList<String> list = new ArrayList<String>();
            for (InstallComponent dependent : comp.getDependentComponents()) {
                if (!dependent.isSelectedForInstall()) continue;
                String compString = dependent.getName() + "," + dependent.getVersion();
                list.add(compString);
            }
            if (list.size() <= 0) continue;
            String format = "{0}:DEPENDENCY_LIST";
            String compKey = MessageFormat.format(format, comp.getName());
            map.put(compKey, list.toArray(new String[0]));
        }
        return map;
    }

    public Map<String, Boolean> buildBooleanMap(ComponentConfig bean) {
        TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
        for (InstallComponent comp : bean.getComponents()) {
            String s = comp.getName().replaceFirst("oracle.", "");
            String compKey = s.replace('.', '_');
            compKey = "oracle_install_comp_" + compKey + "_Selected";
            Boolean selected = comp.isSelectedForInstall();
            map.put(compKey, selected);
        }
        return map;
    }

    public void selectForInstall(ComponentConfig bean, String[] componentIDs) {
        if (componentIDs == null || bean == null) {
            return;
        }
        for (InstallComponent comp : bean.getComponents()) {
            if (comp.isMandatory()) continue;
            comp.setSelectedForInstall(false);
        }
        for (String id : componentIDs) {
            InstallComponent comp = bean.getComponentByID(id);
            if (comp == null) continue;
            comp.setSelectedForInstall(true);
        }
    }

    public static void main(String[] args) throws Exception {
        URL configXmlUrl = ComponentConfigBuilder.class.getResource("/oracle/install/demo/installer/resource/custom_component-config.xml");
        ComponentConfigBuilder builder = ComponentConfigBuilder.getInstance();
        ComponentConfig bean = builder.getComponentBean(configXmlUrl);
        ComponentConfigBuilder.displayBeans(bean);
    }

    private static void displayBeans(Object ... beans) throws BeanStoreException {
        HashMap<String, Object> stringMap = new HashMap<String, Object>();
        BeanStoreUtils.storeAsStringMap(stringMap, beans);
        for (Map.Entry<String, Object> entry : stringMap.entrySet()) {
            Object value = entry.getValue();
            Object[] objectArray = new Object[2];
            objectArray[0] = entry.getKey();
            objectArray[1] = value != null ? (value.getClass().isArray() ? Arrays.deepToString((String[])value) : value.toString()) : "null";
            System.out.printf("%s=%s\n", objectArray);
        }
    }
}

