/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import oracle.install.commons.bean.annotation.BeanDef;
import oracle.install.commons.bean.annotation.PropertyDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BeanDef(value="component")
public class InstallComponent
implements Comparable {
    public static String SELECTION_CHANGED = "InstallComponent.selectedForInstall";
    private String id;
    private String name;
    private String description;
    private String version;
    private boolean selectedForInstall;
    private boolean enabledForSelection;
    private boolean visible;
    private boolean mandatory;
    private List<String> dependants;
    private List<InstallComponent> dependentComponents = new ArrayList<InstallComponent>();
    private PropertyChangeSupport propertyChangeSupport;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener propertyChangeListener_dependee;

    public InstallComponent() {
        this(null, null, true, true);
    }

    public InstallComponent(String name, String version) {
        this(name, version, true, true);
    }

    public InstallComponent(String name, String version, boolean selectedForInstall, boolean enabledForSelection) {
        this.name = name;
        this.version = version;
        this.enabledForSelection = enabledForSelection;
        this.selectedForInstall = selectedForInstall;
        this.dependants = new ArrayList<String>();
        this.dependentComponents = new ArrayList<InstallComponent>();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.propertyChangeListener = new PropertyChangeListener(){
            boolean auto_update = true;

            public void propertyChange(PropertyChangeEvent event) {
                InstallComponent component = (InstallComponent)event.getSource();
                if (InstallComponent.this.isSelectedForInstall() && component.isSelectedForInstall()) {
                    this.auto_update = false;
                }
                if (!InstallComponent.this.isSelectedForInstall()) {
                    this.auto_update = true;
                }
                if (this.auto_update) {
                    InstallComponent.this.setSelectedForInstall(component.isSelectedForInstall());
                }
            }
        };
        this.propertyChangeListener_dependee = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                InstallComponent dependee = (InstallComponent)event.getSource();
                for (InstallComponent dependent : InstallComponent.this.getDependentComponents()) {
                    if (!dependent.isSelectedForInstall() || dependee.isSelectedForInstall()) continue;
                    dependent.setSelectedForInstall(false);
                }
            }
        };
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @PropertyDef(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @PropertyDef(value="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @PropertyDef(value="enabled")
    public boolean isEnabledForSelection() {
        return this.enabledForSelection;
    }

    public void setEnabledForSelection(boolean enabledForSelection) {
        this.enabledForSelection = enabledForSelection;
    }

    public void addParent(InstallComponent component) {
        this.dependentComponents.add(component);
    }

    public InstallComponent getParent(String name) {
        InstallComponent component2 = null;
        for (InstallComponent component2 : this.dependentComponents) {
            if (!component2.getName().equals(name)) continue;
            return component2;
        }
        return component2;
    }

    @PropertyDef(value="dependants")
    public List<String> getDependants() {
        return this.dependants;
    }

    public void setDependants(List<String> dependants) {
        this.dependants = dependants;
    }

    public List<InstallComponent> getDependentComponents() {
        return this.dependentComponents;
    }

    public void setDependentComponents(List<InstallComponent> dependentComponents) {
        this.clear();
        this.dependentComponents = dependentComponents;
        this.registerForPropertyChange();
    }

    private void clear() {
        for (InstallComponent comp : this.dependentComponents) {
            comp.removePropertyChangeListener(SELECTION_CHANGED, this.propertyChangeListener);
        }
    }

    private void registerForPropertyChange() {
        for (InstallComponent dependent : this.dependentComponents) {
            dependent.addPropertyChangeListener(SELECTION_CHANGED, this.propertyChangeListener);
        }
        this.addPropertyChangeListener(SELECTION_CHANGED, this.propertyChangeListener_dependee);
    }

    @PropertyDef(value="selected")
    public boolean isSelectedForInstall() {
        return this.selectedForInstall;
    }

    public void setSelectedForInstall(boolean selectedForInstall) {
        if (this.selectedForInstall != selectedForInstall) {
            boolean oldValue = this.selectedForInstall;
            this.selectedForInstall = selectedForInstall;
            this.propertyChangeSupport.firePropertyChange(SELECTION_CHANGED, oldValue, this.selectedForInstall);
        }
    }

    @PropertyDef(value="visible")
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @PropertyDef(value="desc")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String externalName) {
        this.description = externalName;
    }

    @PropertyDef(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @PropertyDef(value="mandatory")
    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        this.setSelectedForInstall(true);
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int compareTo(Object o) {
        int ret = 1;
        if (o != null) {
            InstallComponent c = (InstallComponent)o;
            ret = this.id.compareTo(c.id);
        }
        return ret;
    }

    public String toString() {
        return this.id;
    }
}

