/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.install.commons.base.util.OracleService;
import oracle.install.commons.base.util.Oratab;
import oracle.install.commons.util.ProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OracleServiceRegistry {
    private static OracleServiceRegistry instance = null;

    public static OracleServiceRegistry getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (proxyFactory = ProxyFactory.getInstance()).createProxy(OracleServiceRegistry.class)) == null) {
            instance = new Oratab();
        }
        return instance;
    }

    protected OracleServiceRegistry() {
    }

    public abstract List<OracleService> getServices();

    public OracleService findServiceById(Pattern pattern) {
        List<OracleService> serviceList;
        OracleService s = null;
        if (pattern != null && (serviceList = this.getServices()) != null) {
            for (OracleService service : serviceList) {
                Matcher matcher = pattern.matcher(service.getSid());
                if (!matcher.matches()) continue;
                return service;
            }
        }
        return s;
    }

    public OracleService findServiceById(String sid) {
        if (sid != null) {
            List<OracleService> serviceList = this.getServices();
            for (OracleService service : serviceList) {
                if (!sid.equals(service.getSid())) continue;
                return service;
            }
        }
        return null;
    }
}

