/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util;

import java.net.InetAddress;
import oracle.install.commons.util.ProxyFactory;
import oracle.sysman.oii.oiix.OiixGeneralQueries;
import oracle.sysman.oii.oiix.OiixNetOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class PlatformInfo {
    private static PlatformInfo instance;

    public static PlatformInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (proxyFactory = ProxyFactory.getInstance()).createProxy(PlatformInfo.class)) == null) {
            instance = new PlatformInfo();
        }
        return instance;
    }

    public int getCurrentPlatform() {
        return OiixPlatform.getCurrentPlatform();
    }

    public int getPlatGroup(int platId) {
        return OiixPlatform.getPlatGroup((int)platId);
    }

    public String getEnv(String varName) {
        return OiixGeneralQueries.getEnv((String)varName);
    }

    public void setEnv(String varName, String value) {
        OiixGeneralQueries.setEnv((String)varName, (String)value);
    }

    public String getDomainName(String hostName) {
        return OiixNetOps.getDomainName((String)hostName);
    }

    public String getFullHostName() {
        try {
            InetAddress local = InetAddress.getLocalHost();
            if (local != null) {
                local = InetAddress.getByName(local.getHostAddress());
                return local.getHostName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String getDefaultCharset() {
        return "WE8MSWIN1252";
    }

    public boolean isWindows() {
        boolean windows = false;
        int platform = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.isPlatInGroup((int)-3, (int)platform)) {
            windows = true;
        }
        return windows;
    }

    public boolean isSolaris() {
        return OiixPlatform.getCurrentPlatform() == 453;
    }
}

