/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean;

import java.util.ArrayList;
import oracle.install.commons.bean.BeanDefinition;
import oracle.install.commons.bean.BeanStore;
import oracle.install.commons.bean.BeanStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanStoreReader<T extends BeanStore> {
    protected BeanStoreReader() {
    }

    public abstract T getBeanStore();

    public abstract void open(T var1) throws BeanStoreException;

    public void close() throws BeanStoreException {
    }

    public void read(Object bean) throws BeanStoreException {
        try {
            Class<?> beanType = bean.getClass();
            BeanDefinition beanDefinition = BeanDefinition.getBeanDefinition(beanType, null);
            if (beanDefinition != null) {
                this.readBean(beanDefinition, bean);
            }
        }
        catch (BeanStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanStoreException(e);
        }
    }

    public Object[] readAll(Class[] beanTypes) throws BeanStoreException {
        ArrayList list = new ArrayList();
        for (Class beanType : beanTypes) {
            Object value = this.read(beanType);
            if (value == null) continue;
            list.add(value);
        }
        return list.toArray();
    }

    public <A> A read(Class<A> beanType) throws BeanStoreException {
        return this.read(beanType, null);
    }

    public <A> A read(Class<A> beanType, String alias) throws BeanStoreException {
        Object bean = null;
        try {
            BeanDefinition beanDefinition = BeanDefinition.getBeanDefinition(beanType, alias);
            if (beanDefinition != null) {
                bean = this.readBean(beanDefinition, null);
            }
        }
        catch (BeanStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanStoreException(e);
        }
        return (A)bean;
    }

    protected abstract Object readBean(BeanDefinition var1, Object var2) throws BeanStoreException;
}

