/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean;

import oracle.install.commons.bean.BeanDefinition;
import oracle.install.commons.bean.BeanStore;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.PropertyDefinition;
import oracle.install.commons.bean.annotation.PropertyDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanStoreWriter<T extends BeanStore> {
    protected BeanStoreWriter() {
    }

    public abstract T getBeanStore();

    public abstract void open(T var1) throws BeanStoreException;

    public void close() throws BeanStoreException {
    }

    protected String mask(String secureContent) {
        return secureContent.replaceAll(".", "*");
    }

    protected boolean isSecurityRequired(PropertyDefinition propertyDefinition) {
        PropertyDef propertyDef = propertyDefinition.getPropertyDef();
        return ((BeanStore)this.getBeanStore()).isSecure() ? (propertyDef != null ? propertyDef.secure() : false) : false;
    }

    protected boolean isPersistable(PropertyDefinition propertyDefinition) {
        PropertyDef propertyDef = propertyDefinition.getPropertyDef();
        return ((BeanStore)this.getBeanStore()).isSecure() ? (propertyDef != null ? propertyDef.persist() : true) : true;
    }

    public void writeAll(Object[] beans) throws BeanStoreException {
        for (Object bean : beans) {
            this.write(bean, null);
        }
    }

    public void write(Object bean) throws BeanStoreException {
        this.write(bean, null);
    }

    public void write(Object bean, String alias) throws BeanStoreException {
        if (bean != null) {
            try {
                BeanDefinition beanDefinition = BeanDefinition.getBeanDefinition(bean.getClass(), alias);
                this.writeBean(bean, beanDefinition);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BeanStoreException(e);
            }
        }
    }

    protected abstract void writeBean(Object var1, BeanDefinition var2) throws BeanStoreException;
}

