/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import oracle.install.commons.bean.TypeTranslator;
import oracle.install.commons.bean.annotation.PropertyDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDefinition<T> {
    private static final Logger logger = Logger.getLogger(PropertyDefinition.class.getName());
    private String name;
    private Class<? extends T> baseType;
    private Method setter;
    private Method getter;
    private String description;
    private PropertyDef propertyDef;

    public PropertyDefinition() {
    }

    public PropertyDefinition(String name, Class<? extends T> baseType, Method setter, Method getter) {
        this.name = name;
        this.baseType = baseType;
        this.setter = setter;
        this.getter = getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public void setSetter(Method setter) {
        this.setter = setter;
    }

    public Method getGetter() {
        return this.getter;
    }

    public void setGetter(Method getter) {
        this.getter = getter;
    }

    public Class<? extends T> getBaseType() {
        return this.baseType;
    }

    public void setBaseType(Class<? extends T> baseType) {
        this.baseType = baseType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T newInstance() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setValue(Object bean, Object value) {
        if (this.setter != null) {
            try {
                this.setter.invoke(bean, value);
            }
            catch (Exception e) {
                logger.warning("Unable to set the value for " + this.name + ". Error: " + e.getMessage());
            }
        }
    }

    public void setValue(Object bean, String value) {
        T newValue = TypeTranslator.translate(value, this.baseType);
        this.setValue(bean, newValue);
    }

    public Object getValue(Object bean) {
        Object value = null;
        if (bean != null) {
            try {
                value = this.getter.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                logger.warning("Unable to get the value for " + this.name + ". Error: " + e.getMessage());
            }
        }
        return value;
    }

    public PropertyDef getPropertyDef() {
        return this.propertyDef;
    }

    public void setPropertyDef(PropertyDef properyDef) {
        this.propertyDef = properyDef;
    }

    public boolean isReadOnly() {
        return this.setter == null;
    }
}

