/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.properties;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.install.commons.bean.ArrayDefinition;
import oracle.install.commons.bean.BeanDefinition;
import oracle.install.commons.bean.BeanStoreErrorCode;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreReader;
import oracle.install.commons.bean.ListDefinition;
import oracle.install.commons.bean.MapDefinition;
import oracle.install.commons.bean.PropertyDefinition;
import oracle.install.commons.bean.TypeTranslator;
import oracle.install.commons.bean.properties.PropertiesBeanStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBeanStoreReader
extends BeanStoreReader<PropertiesBeanStore> {
    private static final Logger logger = Logger.getLogger(PropertiesBeanStoreReader.class.getName());
    private PropertiesBeanStore beanStore;

    @Override
    public PropertiesBeanStore getBeanStore() {
        return this.beanStore;
    }

    @Override
    protected Object readBean(BeanDefinition beanDefinition, Object bean) throws BeanStoreException {
        return this._readBean(beanDefinition, null, bean);
    }

    private Object _readBean(PropertyDefinition propertyDefinition, String value, Object bean) throws BeanStoreException {
        Object returnValue = bean;
        String propertyName = propertyDefinition.getName();
        if (!this.getBeanStore().isCaseSensitive()) {
            propertyName = propertyName.toLowerCase();
        }
        Properties properties = this.getBeanStore().getProperties();
        if (propertyDefinition instanceof BeanDefinition) {
            BeanDefinition beanDefinition = (BeanDefinition)propertyDefinition;
            List<PropertyDefinition> memberDefinitions = beanDefinition.getMemberDefinitions();
            returnValue = bean == null ? beanDefinition.newInstance() : bean;
            for (PropertyDefinition memberDefinition : memberDefinitions) {
                Object propBean = memberDefinition.getValue(returnValue);
                try {
                    Object memberValue = this._readBean(memberDefinition, value, propBean);
                    if (memberValue == null) continue;
                    memberDefinition.setValue(returnValue, memberValue);
                }
                catch (BeanStoreException e) {
                    logger.info(e.getMessage());
                }
            }
        } else {
            String string = value = value == null ? properties.getProperty(propertyName) : value;
            if (value != null) {
                if (propertyDefinition instanceof ListDefinition) {
                    ListDefinition listDefinition = (ListDefinition)propertyDefinition;
                    returnValue = null;
                    String[] items = value.split(",");
                    if (items.length > 0) {
                        PropertyDefinition entryDefinition = listDefinition.getEntryDefinition();
                        List list = listDefinition.newInstance();
                        returnValue = list;
                        for (String item : items) {
                            Object itemValue = this._readBean(entryDefinition, item, null);
                            list.add(itemValue);
                        }
                    }
                } else if (!(propertyDefinition instanceof MapDefinition)) {
                    if (propertyDefinition instanceof ArrayDefinition) {
                        ArrayDefinition arrayDefinition = (ArrayDefinition)propertyDefinition;
                        returnValue = null;
                        String[] items = value.split(",");
                        if (items.length > 0) {
                            PropertyDefinition entryDefinition = arrayDefinition.getEntryDefinition();
                            int n = items.length;
                            returnValue = Array.newInstance(entryDefinition.getBaseType(), n);
                            for (int i = 0; i < n; ++i) {
                                String item = items[i];
                                Object itemValue = this._readBean(entryDefinition, item, null);
                                Array.set(returnValue, i, itemValue);
                            }
                        }
                    } else {
                        returnValue = TypeTranslator.translate(value, propertyDefinition.getBaseType());
                    }
                }
            } else if (!properties.containsKey(propertyName)) {
                throw new BeanStoreException(BeanStoreErrorCode.UNSPECIFIED_PROPERTY, propertyName);
            }
        }
        return returnValue;
    }

    @Override
    public void open(PropertiesBeanStore beanStore) throws BeanStoreException {
        this.beanStore = beanStore;
    }

    @Override
    public void close() throws BeanStoreException {
        this.beanStore = null;
    }
}

