/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.properties;

import java.util.List;
import java.util.Properties;
import oracle.install.commons.bean.BeanDefinition;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreWriter;
import oracle.install.commons.bean.ListDefinition;
import oracle.install.commons.bean.PropertyDefinition;
import oracle.install.commons.bean.properties.PropertiesBeanStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBeanStoreWriter
extends BeanStoreWriter<PropertiesBeanStore> {
    private PropertiesBeanStore beanStore;

    @Override
    public PropertiesBeanStore getBeanStore() {
        return this.beanStore;
    }

    private void writeBean(PropertyDefinition propertyDefinition, Object propertyValue) throws BeanStoreException {
        if (propertyValue == null) {
            return;
        }
        if (!super.isPersistable(propertyDefinition)) {
            return;
        }
        Properties properties = this.getBeanStore().getProperties();
        String propertyName = propertyDefinition.getName();
        if (propertyDefinition instanceof BeanDefinition) {
            BeanDefinition beanDefinition = (BeanDefinition)propertyDefinition;
            List<PropertyDefinition> memberDefinitions = beanDefinition.getMemberDefinitions();
            for (PropertyDefinition memberDefinition : memberDefinitions) {
                Object value = memberDefinition.getValue(propertyValue);
                if (memberDefinition instanceof BeanDefinition) {
                    if (value == null) continue;
                    properties.setProperty(memberDefinition.getName(), value.toString());
                    continue;
                }
                this.writeBean(memberDefinition, value);
            }
        } else if (propertyDefinition instanceof ListDefinition) {
            List list = (List)propertyValue;
            if (list != null) {
                StringBuffer buffer = new StringBuffer();
                for (Object entry : list) {
                    if (entry == null) continue;
                    buffer.append(',');
                    buffer.append(entry.toString());
                }
                if (buffer.charAt(0) == ',') {
                    buffer.deleteCharAt(0);
                }
                properties.setProperty(propertyName, buffer.toString());
            }
        } else {
            String value = propertyValue.toString();
            if (super.isSecurityRequired(propertyDefinition)) {
                value = super.mask(value);
            }
            properties.setProperty(propertyName, value);
        }
    }

    @Override
    protected void writeBean(Object bean, BeanDefinition beanDefinition) throws BeanStoreException {
        this.writeBean(beanDefinition, bean);
    }

    @Override
    public void open(PropertiesBeanStore beanStore) throws BeanStoreException {
        this.beanStore = beanStore;
    }

    @Override
    public void close() throws BeanStoreException {
        this.getBeanStore().save();
        super.close();
    }
}

