/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.xml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.util.XmlSupport;
import oracle.install.commons.util.XmlTag;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PropertyFileFormat
extends XmlBeanStoreFormat {
    private static final EntityResolver RESOLVER = new Resolver();
    private static final String PROPS_DTD_URI = "http://java.sun.com/dtd/properties.dtd";
    private static final String PROPS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for properties --><!ELEMENT properties ( comment?, entry* ) ><!ATTLIST properties version CDATA #FIXED \"1.0\"><!ELEMENT comment (#PCDATA) ><!ELEMENT entry (#PCDATA) ><!ATTLIST entry  key CDATA #REQUIRED>";

    public PropertyFileFormat() {
    }

    public PropertyFileFormat(String namespaceURI, URL raw2extTransformer, URL ext2rawTransformer, URL schema) {
        this(null, namespaceURI, raw2extTransformer, ext2rawTransformer, schema);
    }

    public PropertyFileFormat(String beanStoreName, String namespaceURI, URL raw2extTransformer, URL ext2rawTransformer, URL schema) {
        super(beanStoreName, null, namespaceURI, raw2extTransformer, ext2rawTransformer, schema);
    }

    public Document ext2raw(InputSource source) throws Exception {
        Document rawDoc = null;
        if (source != null) {
            InputStream in = null;
            if (source.getSystemId() != null) {
                URL url = new URL(source.getSystemId());
                in = url.openStream();
            } else {
                in = source.getByteStream();
            }
            if (in != null) {
                Document document = this.toDocument(in);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                XmlSupport.transform(new DOMSource(document), new StreamResult(buffer));
                rawDoc = super.ext2raw(new InputSource(new ByteArrayInputStream(buffer.toByteArray())));
            } else {
                rawDoc = super.ext2raw(source);
            }
        }
        return rawDoc;
    }

    public Document toDocument(InputStream in) throws Exception {
        Properties properties = new Properties();
        properties = this.loadProperties(in);
        in.close();
        XmlTag propertiesTag = XmlTag.createInstance("properties");
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String key = e.getKey().toString();
            String value = e.getValue().toString();
            propertiesTag.setText(key, value);
        }
        return propertiesTag.getDocument();
    }

    public void validate(Source beanStore) throws Exception {
        String systemId = beanStore.getSystemId();
        StreamSource propxml = new StreamSource();
        if (systemId != null) {
            URL url = new URL(systemId);
            InputStream in = url.openStream();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            Document document = this.toDocument(in);
            XmlSupport.transform(new DOMSource(document), new StreamResult(buffer));
            propxml = new StreamSource(new ByteArrayInputStream(buffer.toByteArray()));
        }
        super.validate(propxml);
    }

    public EntityResolver getEntityResolver() {
        return RESOLVER;
    }

    public Properties loadProperties(InputStream in) throws IOException {
        Properties prop = new Properties();
        int lineLength = 0;
        int keyLen = 0;
        int valueStart = 0;
        boolean hasSep = false;
        boolean precedingBackslash = false;
        BufferedReader input = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = input.readLine()) != null) {
            lineLength = line.length();
            valueStart = 0;
            hasSep = false;
            precedingBackslash = false;
            StringBuffer key = new StringBuffer();
            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
            lineLength = line.length();
            for (keyLen = 0; keyLen < lineLength; ++keyLen) {
                char c = line.charAt(keyLen);
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
                key.append(c);
            }
            String value = new String();
            if (hasSep && valueStart > 0) {
                value = line.substring(valueStart);
            }
            if (key.length() <= 0) continue;
            prop.put(key.toString(), value);
        }
        return prop;
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            if (sid.equals(PropertyFileFormat.PROPS_DTD_URI)) {
                InputSource is = new InputSource(new StringReader(PropertyFileFormat.PROPS_DTD));
                is.setSystemId(PropertyFileFormat.PROPS_DTD_URI);
                return is;
            }
            throw new SAXException("Invalid system identifier: " + sid);
        }
    }
}

