/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.xml;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.install.commons.bean.ArrayDefinition;
import oracle.install.commons.bean.BeanDefinition;
import oracle.install.commons.bean.BeanStoreErrorCode;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreReader;
import oracle.install.commons.bean.ListDefinition;
import oracle.install.commons.bean.MapDefinition;
import oracle.install.commons.bean.PropertyDefinition;
import oracle.install.commons.bean.TypeTranslator;
import oracle.install.commons.bean.xml.XmlBeanStore;
import oracle.install.commons.util.exception.Severity;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeanStoreReader
extends BeanStoreReader<XmlBeanStore> {
    private static final Logger logger = Logger.getLogger(XmlBeanStoreReader.class.getName());
    private XmlBeanStore beanStore;
    private Node beanStoreNode;
    private XPath xpath;

    @Override
    public XmlBeanStore getBeanStore() {
        return this.beanStore;
    }

    @Override
    public void open(XmlBeanStore beanStore) throws BeanStoreException {
        this.beanStore = beanStore;
        try {
            Document document = this.beanStore.getDocument();
            this.xpath = XPathFactory.newInstance().newXPath();
            this.beanStoreNode = (Node)this.xpath.evaluate(this.beanStore.getBeanStoreName(), document, XPathConstants.NODE);
        }
        catch (Exception e) {
            throw new BeanStoreException((Throwable)e, BeanStoreErrorCode.UNABLE_TO_OPEN_BEANSTOREREADER, new Object[0]);
        }
    }

    @Override
    public void close() throws BeanStoreException {
        this.beanStoreNode = null;
        this.xpath = null;
        this.beanStore = null;
    }

    @Override
    protected Object readBean(BeanDefinition beanDefinition, Object bean) throws BeanStoreException {
        boolean isParentNode = this.beanStoreNode != null && !beanDefinition.getName().equals(this.beanStoreNode.getNodeName());
        return this.readBean(beanDefinition, bean, this.beanStoreNode, isParentNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readBean(PropertyDefinition propertyDefinition, Object bean, Node node, boolean isParentNode) throws BeanStoreException {
        Object returnValue = null;
        if (node == null) {
            return returnValue;
        }
        String propertyName = propertyDefinition.getName();
        Node propertyNode = null;
        try {
            propertyNode = isParentNode ? (Node)this.xpath.evaluate(propertyName, node, XPathConstants.NODE) : node;
        }
        catch (XPathExpressionException e) {
            throw new BeanStoreException(BeanStoreErrorCode.UNSPECIFIED_PROPERTY, propertyName);
        }
        if (propertyNode == null) throw new BeanStoreException(BeanStoreErrorCode.UNSPECIFIED_PROPERTY, propertyName);
        if (propertyDefinition instanceof BeanDefinition) {
            BeanDefinition beanDefinition = (BeanDefinition)propertyDefinition;
            List<PropertyDefinition> memberDefinitions = beanDefinition.getMemberDefinitions();
            returnValue = bean == null ? beanDefinition.newInstance() : bean;
            Iterator<PropertyDefinition> i$ = memberDefinitions.iterator();
            while (i$.hasNext()) {
                PropertyDefinition memberDefinition = i$.next();
                Object propBean = memberDefinition.getValue(bean);
                try {
                    Object memberValue = this.readBean(memberDefinition, propBean, propertyNode, true);
                    if (memberValue == null) continue;
                    memberDefinition.setValue(returnValue, memberValue);
                }
                catch (BeanStoreException e) {
                    if (e.getSeverity() == Severity.FATAL) {
                        throw e;
                    }
                    logger.warning(e.getMessage());
                }
            }
            return returnValue;
        }
        if (propertyDefinition instanceof ListDefinition) {
            ListDefinition listDefinition = (ListDefinition)propertyDefinition;
            PropertyDefinition entryDefinition = listDefinition.getEntryDefinition();
            try {
                NodeList entryNodes = (NodeList)this.xpath.evaluate(entryDefinition.getName(), propertyNode, XPathConstants.NODESET);
                if (entryNodes == null) return returnValue;
                int n = entryNodes.getLength();
                if (n <= 0) return returnValue;
                List list = listDefinition.newInstance();
                returnValue = list;
                int i = 0;
                while (i < n) {
                    Node entryNode = entryNodes.item(i);
                    Object value = this.readBean(entryDefinition, bean, entryNode, false);
                    list.add(value);
                    ++i;
                }
                return returnValue;
            }
            catch (XPathExpressionException e) {
                logger.warning("Unable to read list entries of '" + propertyName + "'. Error: " + e.getMessage());
                return returnValue;
            }
        } else if (propertyDefinition instanceof MapDefinition) {
            MapDefinition mapDefinition = (MapDefinition)propertyDefinition;
            PropertyDefinition keyDefinition = mapDefinition.getKeyDefinition();
            PropertyDefinition valueDefinition = mapDefinition.getValueDefinition();
            try {
                NodeList entryNodes = (NodeList)this.xpath.evaluate("entry", propertyNode, XPathConstants.NODESET);
                if (entryNodes == null) return returnValue;
                int n = entryNodes.getLength();
                if (n <= 0) return returnValue;
                Map map = mapDefinition.newInstance();
                returnValue = map;
                int i = 0;
                while (i < n) {
                    Object entryKey;
                    Node entryNode = entryNodes.item(i);
                    Node keyNode = (Node)this.xpath.evaluate("key", entryNode, XPathConstants.NODE);
                    if (keyNode != null && (entryKey = this.readBean(keyDefinition, bean, keyNode, false)) != null) {
                        Object entryValue = null;
                        Node valueNode = (Node)this.xpath.evaluate(valueDefinition.getName(), entryNode, XPathConstants.NODE);
                        if (valueNode != null) {
                            entryValue = this.readBean(valueDefinition, bean, valueNode, false);
                        }
                        map.put(entryKey, entryValue);
                    }
                    ++i;
                }
                return returnValue;
            }
            catch (XPathExpressionException e) {
                logger.warning("Unable to read map entries of '" + propertyName + "'. Error: " + e.getMessage());
                return returnValue;
            }
        } else if (propertyDefinition instanceof ArrayDefinition) {
            ArrayDefinition arrayDefinition = (ArrayDefinition)propertyDefinition;
            returnValue = null;
            PropertyDefinition entryDefinition = arrayDefinition.getEntryDefinition();
            try {
                NodeList entryNodes = (NodeList)this.xpath.evaluate(entryDefinition.getName(), propertyNode, XPathConstants.NODESET);
                if (entryNodes == null) return returnValue;
                int n = entryNodes.getLength();
                if (n <= 0) return returnValue;
                returnValue = Array.newInstance(entryDefinition.getBaseType(), n);
                int i = 0;
                while (i < n) {
                    Node entryNode = entryNodes.item(i);
                    Object value = this.readBean(entryDefinition, bean, entryNode, false);
                    Array.set(returnValue, i, value);
                    ++i;
                }
                return returnValue;
            }
            catch (XPathExpressionException e) {
                logger.warning("Unable to read array entries of '" + propertyName + "'. Error: " + e.getMessage());
                return returnValue;
            }
        } else {
            try {
                Node valueNode = (Node)this.xpath.evaluate("text()", propertyNode, XPathConstants.NODE);
                if (valueNode == null) return returnValue;
                try {
                    return TypeTranslator.translate(valueNode.getNodeValue(), propertyDefinition.getBaseType());
                }
                catch (IllegalArgumentException e) {
                    throw new BeanStoreException((Throwable)e, BeanStoreErrorCode.INVALID_ARGUMENT, e.getMessage());
                }
            }
            catch (XPathExpressionException e) {
                logger.warning("Unable to read value of '" + propertyName + "'. Error: " + e.getMessage());
            }
        }
        return returnValue;
    }
}

