/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.xml;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import oracle.install.commons.bean.ArrayDefinition;
import oracle.install.commons.bean.BeanDefinition;
import oracle.install.commons.bean.BeanStoreErrorCode;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreWriter;
import oracle.install.commons.bean.ListDefinition;
import oracle.install.commons.bean.MapDefinition;
import oracle.install.commons.bean.PropertyDefinition;
import oracle.install.commons.bean.xml.XmlBeanStore;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeanStoreWriter
extends BeanStoreWriter<XmlBeanStore> {
    private Node beanStoreNode;
    private XmlBeanStore beanStore;

    @Override
    public XmlBeanStore getBeanStore() {
        return this.beanStore;
    }

    @Override
    public void open(XmlBeanStore beanStore) throws BeanStoreException {
        this.beanStore = beanStore;
        if (beanStore != null) {
            Document document = beanStore.getDocument();
            if (document == null) {
                throw new BeanStoreException(BeanStoreErrorCode.INVALID_BEANSTORE, new Object[0]);
            }
            this.beanStoreNode = document.createElement(beanStore.getBeanStoreName());
            document.appendChild(this.beanStoreNode);
        }
    }

    @Override
    protected void writeBean(Object bean, BeanDefinition beanDefinition) throws BeanStoreException {
        if (this.beanStore == null) {
            throw new BeanStoreException(BeanStoreErrorCode.BEANSTORE_NOT_ASSIGNED_TO_WRITER, new Object[0]);
        }
        this.writeBean(bean, beanDefinition, this.beanStoreNode);
    }

    @Override
    public void close() throws BeanStoreException {
        this.beanStore = null;
        this.beanStoreNode = null;
    }

    private void writeBean(Object propertyValue, PropertyDefinition propertyDefinition, Node node) throws BeanStoreException {
        try {
            Document document = this.beanStore.getDocument();
            if (propertyValue == null) {
                return;
            }
            if (!super.isPersistable(propertyDefinition)) {
                return;
            }
            if (super.isSecurityRequired(propertyDefinition)) {
                return;
            }
            String description = propertyDefinition.getDescription();
            if (description != null && description.trim().length() != 0) {
                Comment comment = document.createComment(description);
                node.appendChild(comment);
            }
            String propertyName = propertyDefinition.getName();
            Element propertyNode = document.createElement(propertyName);
            node.appendChild(propertyNode);
            if (propertyDefinition instanceof BeanDefinition) {
                BeanDefinition beanDefinition = (BeanDefinition)propertyDefinition;
                List<PropertyDefinition> memberDefinitions = beanDefinition.getMemberDefinitions();
                for (PropertyDefinition memberDefinition : memberDefinitions) {
                    Object value = memberDefinition.getValue(propertyValue);
                    this.writeBean(value, memberDefinition, propertyNode);
                }
            } else if (propertyDefinition instanceof ListDefinition) {
                List list = (List)propertyValue;
                ListDefinition listDefinition = (ListDefinition)propertyDefinition;
                PropertyDefinition entryDefinition = listDefinition.getEntryDefinition();
                for (Object entry : list) {
                    this.writeBean(entry, entryDefinition, propertyNode);
                }
            } else if (propertyDefinition instanceof MapDefinition) {
                MapDefinition mapDefinition = (MapDefinition)propertyDefinition;
                PropertyDefinition keyDefinition = mapDefinition.getKeyDefinition();
                PropertyDefinition valueDefinition = mapDefinition.getValueDefinition();
                Map map = (Map)propertyValue;
                for (Map.Entry entry : map.entrySet()) {
                    Element entryNode = document.createElement("entry");
                    propertyNode.appendChild(entryNode);
                    this.writeBean(entry.getKey(), keyDefinition, entryNode);
                    this.writeBean(entry.getValue(), valueDefinition, entryNode);
                }
            } else if (propertyDefinition instanceof ArrayDefinition) {
                ArrayDefinition arrayDefinition = (ArrayDefinition)propertyDefinition;
                PropertyDefinition entryDefinition = arrayDefinition.getEntryDefinition();
                int length = Array.getLength(propertyValue);
                for (int i = 0; i < length; ++i) {
                    Object entry = Array.get(propertyValue, i);
                    this.writeBean(entry, entryDefinition, propertyNode);
                }
            } else {
                String value = null;
                value = propertyValue.getClass().isEnum() ? ((Enum)propertyValue).name() : propertyValue.toString();
                Text textNode = document.createTextNode(value);
                propertyNode.appendChild(textNode);
            }
        }
        catch (Exception e) {
            throw new BeanStoreException(e);
        }
    }
}

