/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.install.commons.bean.annotation.BeanDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowBeanRegistry {
    private static final Logger logger = Logger.getLogger(FlowBeanRegistry.class.getName());
    private static Map<String, Class<? extends Object>> beanMappings = new HashMap<String, Class<? extends Object>>();

    public static Object createBean(String id) throws Exception {
        Object bean = null;
        Class<? extends Object> beanType = beanMappings.get(id);
        if (beanType != null) {
            bean = beanType.newInstance();
        }
        return bean;
    }

    public static String getBeanId(Class<? extends Object> beanType) {
        String beanId = null;
        BeanDef beanDef = beanType.getAnnotation(BeanDef.class);
        if (beanDef != null) {
            beanId = beanDef.value();
        } else {
            logger.warning("Annotation named @BeanDef not defined for the class - " + beanType);
        }
        return beanId;
    }

    public static Class getBeanType(String id) {
        return beanMappings.get(id);
    }

    public static Class<? extends Object> addBeanType(String beanType) throws Exception {
        Class<?> type = Class.forName(beanType);
        if (type != null) {
            FlowBeanRegistry.addBeanType(type);
        }
        return type;
    }

    public static void addBeanType(Class<? extends Object> beanType) {
        String id = FlowBeanRegistry.getBeanId(beanType);
        if (id != null) {
            beanMappings.put(id, beanType);
        }
    }

    public static List<Class<? extends Object>> getRegisteredBeanTypes() {
        return Collections.unmodifiableList(new ArrayList<Class<? extends Object>>(beanMappings.values()));
    }
}

