/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.install.commons.bean.BeanStore;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreFactory;
import oracle.install.commons.bean.BeanStoreReader;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.bean.properties.PropertiesBeanStore;
import oracle.install.commons.bean.xml.PropertyFileFormat;
import oracle.install.commons.bean.xml.XmlBeanStore;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatRegistry;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.Flow;
import oracle.install.commons.flow.FlowBeanRegistry;
import oracle.install.commons.flow.FlowConfigErrorCode;
import oracle.install.commons.flow.FlowConfigException;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowDataSource;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.StateType;
import oracle.install.commons.flow.ViewManager;
import oracle.install.commons.flow.ViewManagerException;
import oracle.install.commons.util.Graph;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.ExceptionManager;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class FlowBuilder {
    private static final Logger logger = Logger.getLogger(FlowBuilder.class.getName());
    private static FlowBuilder instance;
    private XPath xpath;
    private Map<Class<?>, Object> flowDataMap = new HashMap();

    public static FlowBuilder getInstance() {
        if (instance == null) {
            instance = new FlowBuilder();
        }
        return instance;
    }

    private FlowBuilder() {
    }

    public void registerFlowData(Object flowData) {
        if (flowData != null) {
            this.flowDataMap.put(flowData.getClass(), flowData);
        }
    }

    public void reset() {
        this.flowDataMap.clear();
    }

    public FlowContext buildFlow(URL flowConfig) throws FlowConfigException {
        return this.buildFlow(flowConfig, null, null);
    }

    public FlowContext buildFlow(URL flowConfig, FlowDataSource flowData) throws FlowConfigException {
        return this.buildFlow(flowConfig, flowData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowContext buildFlow(URL flowConfig, FlowDataSource flowDataSource, Properties flowDataDefaults) throws FlowConfigException {
        FlowContext flowContext = new FlowContext();
        InputStream configStream = null;
        try {
            configStream = flowConfig.openStream();
            InputSource source = new InputSource(configStream);
            this.xpath = XPathFactory.newInstance().newXPath();
            Node flowConfigNode = null;
            try {
                flowConfigNode = (Node)this.xpath.evaluate("flow-config", source, XPathConstants.NODE);
            }
            catch (XPathExpressionException e) {
                throw new FlowConfigException((Throwable)e, FlowConfigErrorCode.INVALID_FLOW_CONFIG, new Object[0]);
            }
            NodeList flowNodeList = null;
            try {
                flowNodeList = (NodeList)this.xpath.evaluate("flow", flowConfigNode, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                throw new FlowConfigException((Throwable)e, FlowConfigErrorCode.INVALID_FLOW_CONFIG, new Object[0]);
            }
            Node flowNode = null;
            int n = flowNodeList.getLength();
            TreeMap<String, Flow> flowMap = new TreeMap<String, Flow>();
            for (int i = 0; i < n; ++i) {
                flowNode = flowNodeList.item(i);
                Flow flow = this.buildFlow(flowNode);
                flowMap.put(flow.getId(), flow);
            }
            Node node = flowConfigNode.getAttributes().getNamedItem("start-flow");
            String flowId = node.getNodeValue();
            Flow startFlow = (Flow)flowMap.get(flowId);
            Graph<Route, State> rootVertex = startFlow.getRootVertex();
            State state = rootVertex.getValue();
            state.setStartState(true);
            flowContext.setFlow(rootVertex);
            logger.info("Linking states ");
            for (Map.Entry flowEntry : flowMap.entrySet()) {
                Flow flow = (Flow)flowEntry.getValue();
                for (Map.Entry<String, Graph<Route, State>> stateEntry : flow.getStateMap().entrySet()) {
                    String id = stateEntry.getKey();
                    Graph<Route, State> graph = stateEntry.getValue();
                    TreeMap<String, String> transitionMap = flow.getStateTransitionMap().get(id);
                    for (Map.Entry<String, String> transitionEntry : transitionMap.entrySet()) {
                        String event = transitionEntry.getKey();
                        String to = transitionEntry.getValue();
                        Graph<Route, State> vertex = null;
                        if (to.startsWith("flow:")) {
                            flowId = to.substring(5);
                            Flow externalFlow = (Flow)flowMap.get(flowId);
                            vertex = externalFlow.getRootVertex();
                        } else {
                            vertex = flow.getStateMap().get(to);
                        }
                        if (vertex == null) {
                            throw new FlowConfigException(FlowConfigErrorCode.INVALID_ROUTE_IDENTIFIER, to, id);
                        }
                        logger.info("State[" + id + "]: route=" + event + "; to=" + vertex.getValue().getId());
                        graph.setGraph(new Route(event), vertex);
                    }
                }
            }
            logger.info("Successfully built the flow");
            BeanStore[] beanStores = this.openBeanStores(flowDataSource, flowDataDefaults);
            this.loadBeans(flowConfigNode, flowContext, beanStores);
            this.closeBeanStores(beanStores);
            this.loadViews(flowConfigNode);
        }
        catch (IOException e) {
            logger.severe("Failed to read flow config");
            ExceptionManager.handle(e);
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (IOException e) {
                    ExceptionManager.handle(e);
                }
            }
        }
        return flowContext;
    }

    private Flow buildFlow(Node flowNode) throws FlowConfigException {
        Flow flow = new Flow();
        NodeList nl = null;
        try {
            nl = (NodeList)this.xpath.evaluate("state", flowNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new FlowConfigException((Throwable)e, FlowConfigErrorCode.INVALID_FLOW_CONFIG, new Object[0]);
        }
        int n = nl.getLength();
        logger.info("Building the flow graph");
        for (int i = 0; i < n; ++i) {
            Node node = nl.item(i);
            State state = this.buildState(node, flow);
            Graph graph = new Graph(state);
            flow.getStateMap().put(state.getId(), graph);
            logger.info("Loaded state " + state.getId());
        }
        Node attr = flowNode.getAttributes().getNamedItem("id");
        String id = attr.getNodeValue();
        flow.setId(id);
        attr = flowNode.getAttributes().getNamedItem("start-state");
        String startStateId = attr.getNodeValue();
        Graph<Route, State> rootVertex = flow.getStateMap().get(startStateId);
        flow.setRootVertex(rootVertex);
        return flow;
    }

    private State buildState(Node stateNode, Flow flow) throws FlowConfigException {
        State state = new State();
        NamedNodeMap attributes = stateNode.getAttributes();
        Node attrId = attributes.getNamedItem("id");
        Node attrType = attributes.getNamedItem("type");
        Node attrAction = attributes.getNamedItem("action");
        Node attrView = attributes.getNamedItem("view");
        Node attrDefault = attributes.getNamedItem("default");
        Node attrCheckpoint = attributes.getNamedItem("checkpoint");
        Node attrValidator = attributes.getNamedItem("validator");
        String id = attrId.getNodeValue();
        state.setId(id);
        if (attrView != null) {
            String viewId = attrView.getNodeValue();
            if (viewId.trim().length() == 0) {
                throw new FlowConfigException(FlowConfigErrorCode.UNKNOWN_VIEW, new Object[0]);
            }
            state.setViewId(viewId);
        }
        if (attrCheckpoint != null) {
            boolean checkpointEnabled = Boolean.valueOf(attrCheckpoint.getNodeValue());
            state.setCheckpointEnabled(checkpointEnabled);
        }
        if (attrValidator != null) {
            String validatorId = attrValidator.getNodeValue();
            if (validatorId.trim().length() == 0) {
                throw new FlowConfigException(FlowConfigErrorCode.UNKNOWN_VALIDATOR, new Object[0]);
            }
            state.setValidatorId(validatorId);
        }
        if (attrType != null) {
            String type = attrType.getNodeValue();
            try {
                Field field = StateType.class.getField(type);
                StateType stateType = (StateType)((Object)field.get(null));
                state.setStateType(stateType);
            }
            catch (Exception e) {
                logger.warning("Unknown state type " + type);
            }
        }
        if (attrDefault != null) {
            String defaultRouteId = attrDefault.getNodeValue();
            state.setDefaultRoute(new Route(defaultRouteId));
        }
        NodeList transitions = null;
        int transitionsCount = 0;
        try {
            transitions = (NodeList)this.xpath.evaluate("transition", stateNode, XPathConstants.NODESET);
            transitionsCount = transitions.getLength();
        }
        catch (XPathExpressionException e) {
            // empty catch block
        }
        TreeMap<String, String> transitionMap = new TreeMap<String, String>();
        for (int j = 0; j < transitionsCount; ++j) {
            Node transitionNode = transitions.item(j);
            NamedNodeMap transitionAttributes = transitionNode.getAttributes();
            Node attrOn = transitionAttributes.getNamedItem("on");
            Node attrTo = transitionAttributes.getNamedItem("to");
            String on = attrOn.getNodeValue();
            String to = attrTo.getNodeValue();
            transitionMap.put(on, to);
        }
        flow.getStateTransitionMap().put(id, transitionMap);
        Action action = null;
        if (attrAction != null) {
            String actionClass = attrAction.getNodeValue();
            try {
                Class<?> clazz = Class.forName(actionClass);
                action = (Action)clazz.newInstance();
            }
            catch (Exception e) {
                throw new FlowConfigException((Throwable)e, FlowConfigErrorCode.INVALID_ACTION_DEFINITION, new Object[0]);
            }
        } else {
            action = transitionsCount > 0 ? new DefaultAction() : new DefaultAction(Route.FINISH);
        }
        state.setAction(action);
        state.setFinishState(transitionsCount == 0);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBeans(Node flowConfigNode, FlowContext flowContext, BeanStore ... beanStores) throws FlowConfigException {
        BeanStoreReader[] readers = this.openBeanStoreReaders(beanStores);
        logger.info("Registering the flow data beans");
        this.xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nl = (NodeList)this.xpath.evaluate("beans/bean", flowConfigNode, XPathConstants.NODESET);
            int n = nl.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nl.item(i);
                this.loadBean(node, flowContext, readers);
            }
        }
        catch (XPathExpressionException e) {
            logger.info("No Bean Definition found");
        }
        finally {
            this.closeBeanStoreReaders(readers);
        }
    }

    private void loadBean(Node beanNode, FlowContext flowContext, BeanStoreReader ... beanStoreReaders) throws FlowConfigException {
        Object bean = null;
        NamedNodeMap attributes = beanNode.getAttributes();
        Node attrClass = attributes.getNamedItem("class");
        String className = attrClass.getNodeValue();
        try {
            Class<? extends Object> beanType = FlowBeanRegistry.addBeanType(className);
            if (beanType != null) {
                flowContext.addRequiredBeanType(beanType);
                bean = this.flowDataMap.get(beanType);
                for (BeanStoreReader reader : beanStoreReaders) {
                    if (reader == null) continue;
                    if (bean != null) {
                        reader.read(bean);
                        continue;
                    }
                    bean = reader.read(beanType);
                }
                if (bean != null) {
                    String beanId = FlowBeanRegistry.getBeanId(beanType);
                    flowContext.setBean(beanId, bean);
                    logger.log(Level.INFO, "Set value for bean {0}", beanId);
                } else {
                    logger.log(Level.INFO, "Value not found for {0}", beanType);
                }
            }
        }
        catch (Exception e) {
            logger.warning("Failed to load bean " + className + ". Reason: " + e.getMessage());
        }
    }

    private BeanStore[] openBeanStores(FlowDataSource flowDataSource, Properties flowDataDefaults) {
        XmlBeanStoreFormat format;
        logger.log(Level.INFO, "Opening bean stores from which the beans can be loaded");
        ArrayList<BeanStore> beanStores = new ArrayList<BeanStore>();
        boolean flowDataDefaultsExist = flowDataDefaults != null && !flowDataDefaults.isEmpty();
        Properties properties = new Properties();
        properties.putAll(System.getenv());
        beanStores.add(new PropertiesBeanStore(properties, true));
        if (flowDataDefaultsExist) {
            FlowBuilder.safeCopy(flowDataDefaults, properties);
        }
        if (flowDataSource != null && flowDataSource.getSourceURL() != null) {
            XmlBeanStoreFormat format2;
            if (!properties.isEmpty() && (format2 = flowDataSource.getFormat()) instanceof PropertyFileFormat) {
                logger.log(Level.INFO, "Changing the format to extended property file format to merge the flowDataDefaults with the flowDataSource");
                flowDataSource.setFormat(new ExtendedPropertyFileFormat((PropertyFileFormat)format2, flowDataDefaults));
            }
            BeanStoreFactory beanStoreFactory = BeanStoreFactory.getInstance();
            try {
                Object beanStore = beanStoreFactory.newBeanStore(flowDataSource);
                ((BeanStore)beanStore).setBeanStoreName(flowDataSource.getBeanStoreName());
                beanStores.add((BeanStore)beanStore);
            }
            catch (BeanStoreException e) {
                ExceptionManager.handle(e);
            }
            catch (Exception e) {
                ExceptionManager.handle(e);
            }
            logger.log(Level.INFO, "Loaded BeanStore using the flow data source");
        } else if (!properties.isEmpty() && (format = XmlBeanStoreFormatRegistry.getInstance().getDefaultFormat()) instanceof PropertyFileFormat) {
            try {
                XmlBeanStore beanStore = BeanStoreUtils.createXmlBeanStore((PropertyFileFormat)format, properties);
                beanStore.setBeanStoreName(format.getBeanStoreName());
                beanStores.add(beanStore);
            }
            catch (BeanStoreException e) {
                ExceptionManager.handle(e);
            }
        }
        if (flowDataDefaultsExist) {
            beanStores.add(new PropertiesBeanStore(flowDataDefaults, false));
            logger.log(Level.INFO, "Loaded BeanStore using the flow data defaults");
        }
        return beanStores.toArray(new BeanStore[0]);
    }

    private void closeBeanStores(BeanStore ... beanStores) {
        logger.log(Level.INFO, "Closing bean stores from which the beans can be loaded");
        if (beanStores != null) {
            for (BeanStore beanStore : beanStores) {
                try {
                    beanStore.close();
                }
                catch (BeanStoreException e) {
                    logger.log(Level.WARNING, "Failed to close bean store", e);
                }
            }
        }
    }

    private BeanStoreReader[] openBeanStoreReaders(BeanStore ... beanStores) {
        ArrayList readers = new ArrayList();
        for (BeanStore beanStore : beanStores) {
            try {
                readers.add(beanStore.newBeanStoreReader());
            }
            catch (BeanStoreException e) {
                logger.log(Level.WARNING, "Failed to create bean store reader", e);
            }
        }
        return readers.toArray(new BeanStoreReader[0]);
    }

    private void closeBeanStoreReaders(BeanStoreReader ... readers) {
        if (readers != null) {
            for (BeanStoreReader reader : readers) {
                try {
                    reader.close();
                }
                catch (BeanStoreException e) {
                    logger.log(Level.WARNING, "Failed to close bean store reader", e);
                }
            }
        }
    }

    private void loadViews(Node flowConfigNode) throws FlowConfigException {
        logger.info("Registering the flow views");
        try {
            NodeList nl = (NodeList)this.xpath.evaluate("views/view", flowConfigNode, XPathConstants.NODESET);
            int n = nl.getLength();
            UIType uiType = null;
            for (int i = 0; i < n; ++i) {
                Node attrUIType;
                Node attrName;
                String viewId = null;
                String className = null;
                Node node = nl.item(i);
                NamedNodeMap attributes = node.getAttributes();
                Node attrClass = attributes.getNamedItem("class");
                if (attrClass != null) {
                    className = attrClass.getNodeValue();
                }
                if ((attrName = attributes.getNamedItem("name")) != null) {
                    viewId = attrName.getNodeValue();
                }
                if ((attrUIType = attributes.getNamedItem("uiType")) != null) {
                    String value = attrUIType.getNodeValue();
                    if (UIType.GRAPHICAL.name().equals(value)) {
                        uiType = UIType.GRAPHICAL;
                    } else if (UIType.TEXTUAL.name().equals(value)) {
                        uiType = UIType.TEXTUAL;
                    }
                }
                if (className == null) continue;
                try {
                    ViewManager.addViewType(className, viewId, uiType);
                    continue;
                }
                catch (ViewManagerException e) {
                    throw new FlowConfigException((Throwable)e, FlowConfigErrorCode.INVALID_VIEW_DEFINITION, new Object[0]);
                }
            }
        }
        catch (XPathExpressionException e) {
            logger.info("No View definition found.");
        }
    }

    private static Properties safeCopy(Properties source, Properties target) {
        for (Map.Entry<Object, Object> e : source.entrySet()) {
            Object value = e.getValue();
            if (!(value instanceof String)) continue;
            String string = (String)value;
            if ((string = string.trim()).length() <= 0) continue;
            target.put(e.getKey(), value);
        }
        return target;
    }

    class ExtendedPropertyFileFormat
    extends PropertyFileFormat {
        private Properties defaults;

        public ExtendedPropertyFileFormat(PropertyFileFormat sourceFormat, Properties defaults) {
            super(sourceFormat.getBeanStoreName(), sourceFormat.getNamespaceURI(), sourceFormat.getRaw2extTransformer(), sourceFormat.getExt2rawTransformer(), sourceFormat.getSchema());
            this.defaults = defaults;
        }

        public Properties loadProperties(InputStream in) throws IOException {
            Properties properties = new Properties();
            properties.putAll(System.getenv());
            FlowBuilder.safeCopy(super.loadProperties(in), properties);
            if (this.defaults != null) {
                FlowBuilder.safeCopy(this.defaults, properties);
            }
            return properties;
        }
    }
}

