/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.install.commons.flow.FlowBeanRegistry;
import oracle.install.commons.flow.FlowControl;
import oracle.install.commons.flow.FlowDirection;
import oracle.install.commons.flow.FlowExecutionMode;
import oracle.install.commons.flow.FlowExecutor;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.RoutePlanChangeEvent;
import oracle.install.commons.flow.RoutePlanChangeListener;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.Transition;
import oracle.install.commons.util.Bean;
import oracle.install.commons.util.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowContext
extends Bean
implements RoutePlanChangeListener {
    private static final Logger logger = Logger.getLogger(FlowContext.class.getName());
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, Object> beans = new HashMap<String, Object>();
    private List<Class> requiredBeanTypes = new ArrayList<Class>();
    private Graph<Route, State> flow;
    private Graph<Route, State> currentVertex;
    private FlowExecutor flowExecutor;
    private FlowExecutorType flowExecutionType;
    private FlowExecutionMode flowExecutionMode;
    private FlowControl flowControl;
    private RoutePlan routePlan;
    private FlowDirection flowDirection = FlowDirection.FORWARD;
    private Transition transition;

    public FlowDirection getFlowDirection() {
        return this.flowDirection;
    }

    protected void setFlowDirection(FlowDirection flowDirection) {
        this.flowDirection = flowDirection;
    }

    public RoutePlan getRoutePlan() {
        return this.routePlan;
    }

    @Override
    public void stateChanged(RoutePlanChangeEvent e) {
        int eventId = e.getId();
        if ((eventId & 1) == 1) {
            this.routePlan = e.getSource();
            this.currentVertex = this.routePlan.getCurrentVertex();
        }
    }

    protected void addRequiredBeanType(Class beanType) {
        this.requiredBeanTypes.add(beanType);
    }

    public List<Class> getRequiredBeanTypes() {
        return this.requiredBeanTypes;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void addBean(Object bean) {
        String beanId;
        if (bean != null && (beanId = FlowBeanRegistry.getBeanId(bean.getClass())) != null) {
            this.setBean(beanId, bean);
        }
    }

    public void removeBean(Object bean) {
        String beanId;
        if (bean != null && (beanId = FlowBeanRegistry.getBeanId(bean.getClass())) != null) {
            this.beans.remove(beanId);
        }
    }

    public <A> A getBean(Class<A> beanType) {
        String beanId = FlowBeanRegistry.getBeanId(beanType);
        return (A)this.getBean(beanId);
    }

    public <A> A getBeanLike(Class<A> beanType) {
        A bean = null;
        for (Object item : this.getBeans()) {
            if (!beanType.isAssignableFrom(item.getClass())) continue;
            bean = (A)item;
            break;
        }
        if (bean == null) {
            for (Class type : this.getRequiredBeanTypes()) {
                if (!beanType.isAssignableFrom(type)) continue;
                bean = this.getBean(type);
                break;
            }
        }
        return bean;
    }

    public Object getBean(String id) {
        Object bean = null;
        if (id != null && (bean = this.beans.get(id)) == null) {
            try {
                bean = FlowBeanRegistry.createBean(id);
                if (bean != null) {
                    this.beans.put(id, bean);
                    logger.info("Registered bean [" + id + "]");
                }
            }
            catch (Exception e) {
                logger.warning("Failed to create bean [" + id + "]");
            }
        }
        return bean;
    }

    public void setBean(String id, Object bean) {
        Object oldBean = this.beans.get(id);
        if (oldBean != bean) {
            this.beans.put(id, bean);
            this.propertyChangeSupport.firePropertyChange(id, oldBean, bean);
        }
    }

    public Graph<Route, State> getCurrentVertex() {
        return this.currentVertex;
    }

    public void setCurrentVertex(Graph<Route, State> currentVertex) {
        this.currentVertex = currentVertex;
    }

    public Graph<Route, State> getFlow() {
        return this.flow;
    }

    protected void setFlow(Graph<Route, State> flow) {
        this.flow = flow;
        this.currentVertex = flow;
    }

    public FlowExecutorType getFlowExecutionType() {
        return this.flowExecutionType;
    }

    public void setFlowExecutionType(FlowExecutorType flowExecutionType) {
        this.flowExecutionType = flowExecutionType;
    }

    public FlowExecutionMode getFlowExecutionMode() {
        return this.flowExecutionMode;
    }

    public void setFlowExecutionMode(FlowExecutionMode flowExecutionMode) {
        this.flowExecutionMode = flowExecutionMode;
    }

    public FlowControl getFlowControl() {
        return this.flowControl;
    }

    public void setFlowControl(FlowControl flowControl) {
        this.flowControl = flowControl;
    }

    public List getBeans() {
        return Collections.unmodifiableList(new ArrayList<Object>(this.beans.values()));
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    protected void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public boolean isSuccessfullyExecuted() {
        boolean success = false;
        if (this.currentVertex != null) {
            success = this.currentVertex.isTerminal();
        }
        return success;
    }

    public Transition getTransition() {
        return this.transition;
    }

    protected void setTransition(Transition transition) {
        this.transition = transition;
    }
}

