/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowDataSource;

public class FlowDataRecorder {
    private static final Logger logger = Logger.getLogger(FlowDataRecorder.class.getName());
    private static FlowDataRecorder instance = null;
    private FlowDataSource flowDataSource = new FlowDataSource();
    private File recordFile;
    private boolean enabled = true;

    public static FlowDataRecorder getInstance() {
        if (instance == null) {
            instance = new FlowDataRecorder();
        }
        return instance;
    }

    private FlowDataRecorder() {
    }

    public FlowDataSource getFlowDataSource() {
        return this.flowDataSource;
    }

    public void setFlowDataSource(FlowDataSource flowDataSource) {
        this.flowDataSource = flowDataSource;
    }

    public File getRecordFile() {
        return this.recordFile;
    }

    public void setRecordFile(File recordFile) {
        this.recordFile = recordFile;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void record(FlowContext flowContext) {
        if (this.isEnabled()) {
            if (this.recordFile == null) {
                logger.warning("Failed to record. Destination file not set.");
                return;
            }
            List beans = flowContext.getBeans();
            if (!beans.isEmpty()) {
                try {
                    String beanStoreName = null;
                    if (this.flowDataSource != null) {
                        beanStoreName = this.flowDataSource.getBeanStoreName();
                    }
                    logger.log(Level.INFO, "Recording flow data to {0}", this.recordFile);
                    BeanStoreUtils.storeAsXML(this.recordFile, beanStoreName, true, beans.toArray());
                    logger.log(Level.INFO, "Successfully recorded flow data to {0}", this.recordFile);
                }
                catch (BeanStoreException e) {
                    logger.log(Level.WARNING, "Failed to record flow data to " + this.recordFile, e);
                }
            }
        }
    }
}

