/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.util.Set;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.State;
import oracle.install.commons.util.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowHelper {
    public static State findState(FlowContext flowContext, String stateId) {
        State state = null;
        Graph<Route, State> vertex = FlowHelper.findVertex(flowContext.getCurrentVertex(), stateId);
        if (vertex != null) {
            state = vertex.getValue();
        }
        return state;
    }

    public static Graph<Route, State> findVertex(Graph<Route, State> vertex, String stateId) {
        State currentState = vertex.getValue();
        if (stateId.equals(currentState.getId())) {
            return vertex;
        }
        Set<Route> edges = vertex.getEdges();
        for (Route edge : edges) {
            Graph<Route, State> siblingVertex = vertex.getGraph(edge);
            Graph<Route, State> expectedVertex = FlowHelper.findVertex(siblingVertex, stateId);
            if (expectedVertex == null) continue;
            return expectedVertex;
        }
        return null;
    }

    public static boolean isSilentMode(FlowContext flowContext) {
        return flowContext != null && flowContext.getFlowExecutionType() == FlowExecutorType.SILENT;
    }
}

