/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.util.exception.ExceptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowWorker {
    private static final Logger logger = Logger.getLogger(FlowWorker.class.getName());
    private FlowContext flowContext;
    private ExecutorService executor;
    private Map<FutureFlowTask<?>, Future<?>> futureMap;
    private ThreadFactory threadFactory;

    public static FlowWorker getInstance(FlowContext flowContext) {
        FlowWorker instance = (FlowWorker)flowContext.getAttribute(FlowWorker.class.getName());
        if (instance == null) {
            instance = new FlowWorker(flowContext);
            flowContext.setAttribute(FlowWorker.class.getName(), instance);
        }
        return instance;
    }

    private FlowWorker(FlowContext flowContext) {
        this.flowContext = flowContext;
        this.threadFactory = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                String currentStateId = FlowWorker.this.flowContext.getCurrentVertex().getValue().getId();
                t.setName(currentStateId + ".flowWorker");
                return t;
            }
        };
        this.executor = Executors.newSingleThreadExecutor(this.threadFactory);
        this.futureMap = new HashMap();
    }

    public FlowContext getFlowContext() {
        return this.flowContext;
    }

    public <A> Future<A> perform(Callable<A> callable) {
        if (this.executor.isShutdown()) {
            this.executor = Executors.newSingleThreadExecutor(this.threadFactory);
        }
        FutureFlowTask<A> task = new FutureFlowTask<A>(callable);
        Future<?> future = this.executor.submit(task);
        this.futureMap.put(task, future);
        return future;
    }

    public boolean isBusy() {
        boolean busy = false;
        for (Future<?> future : this.futureMap.values()) {
            if (future.isDone()) continue;
            busy = true;
            break;
        }
        return busy;
    }

    public void waitForCompletion() throws InterruptedException {
        if (this.isBusy() || !this.executor.isShutdown()) {
            String stateId = this.flowContext.getCurrentVertex().getValue().getId();
            logger.log(Level.INFO, "Finishing all forked tasks at state " + stateId);
            this.executor.shutdown();
            logger.log(Level.INFO, "Waiting for completion all forked tasks at state " + stateId);
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            logger.log(Level.INFO, "All forked task are completed at state " + stateId);
        }
    }

    public void terminate() {
        if (this.isBusy() || !this.executor.isShutdown()) {
            logger.info("Terminate Flow Worker");
            this.executor.shutdownNow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FutureFlowTask<V>
    extends FutureTask<V> {
        public FutureFlowTask(Callable<V> callable) {
            super(callable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            ExceptionManager exceptionManager = ExceptionManager.getInstance();
            try {
                this.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                exceptionManager.reportException(cause);
            }
            catch (InterruptedException e) {
                exceptionManager.reportException(e);
            }
            finally {
                FlowWorker.this.futureMap.remove(this);
            }
        }
    }
}

