/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.ViewManagerErrorCode;
import oracle.install.commons.flow.ViewManagerException;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.ErrorCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewManager {
    private static Logger logger = Logger.getLogger(ViewManager.class.getName());
    private static Map<String, Object> cache = new HashMap<String, Object>();

    public static List<View> getAllRegisteredViews() {
        ArrayList<View> views = new ArrayList<View>();
        for (Map.Entry<String, Object> entry : cache.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof View)) continue;
            views.add((View)value);
        }
        return views;
    }

    public static View getView(String viewId) throws ViewManagerException {
        logger.info("Get view named [" + viewId + "]");
        View view = null;
        Object value = cache.get(viewId);
        if (value != null) {
            if (value instanceof View) {
                view = (View)value;
            } else if (value instanceof Class) {
                try {
                    view = (View)((Class)value).newInstance();
                    Application application = Application.getInstance();
                    application.registerComponentForHelp(view.getView(), viewId);
                    cache.put(viewId, view);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to load the view [" + viewId + "] . Reason: ", e);
                    throw new ViewManagerException((Throwable)e, (ErrorCode)ViewManagerErrorCode.INVALID_VIEW_CLASS, viewId);
                }
            }
        }
        logger.info("View for [" + viewId + "] is " + view);
        return view;
    }

    public static View getView(Action action) throws ViewManagerException {
        View view = null;
        String id = ViewManager.getViewId(action);
        if (id != null) {
            view = ViewManager.getView(id);
        }
        return view;
    }

    public static String getViewId(Action action) throws ViewManagerException {
        UIRef ui;
        String id = null;
        if (action != null && (ui = action.getClass().getAnnotation(UIRef.class)) != null) {
            id = ui.value();
        }
        return id;
    }

    public static String addViewType(String viewType, String viewId, UIType uiType) throws ViewManagerException {
        ViewDef viewDef;
        logger.info("Adding View[type: " + viewType + " viewId: " + viewId + " uiType: " + (Object)((Object)uiType) + "]");
        String _viewId = viewId;
        Class<?> viewClass = null;
        try {
            viewClass = Class.forName(viewType);
        }
        catch (ClassNotFoundException e) {
            throw new ViewManagerException((Throwable)e, (ErrorCode)ViewManagerErrorCode.VIEW_CLASS_NOT_FOUND, viewId);
        }
        if ((viewId == null || uiType == null) && (viewDef = viewClass.getAnnotation(ViewDef.class)) != null) {
            if (viewId == null) {
                viewId = viewDef.id();
            }
            if (uiType == null) {
                uiType = viewDef.type();
            }
        }
        Application application = Application.getInstance();
        UIType applicationUIType = application.getUIType();
        if (viewId != null && applicationUIType == uiType) {
            cache.put(viewId, viewClass);
            logger.info(viewType + " added to View Type Registry with the key as [" + viewId + "]");
        }
        return _viewId;
    }

    public static String addViewType(String viewType) throws ViewManagerException {
        return ViewManager.addViewType(viewType, null, null);
    }
}

