/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.checkpoint;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.flow.FlowBeanRegistry;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.checkpoint.Checkpoint;
import oracle.install.commons.flow.checkpoint.CheckpointHandler;
import oracle.install.commons.util.Graph;

public class DefaultCheckpointHandler
extends CheckpointHandler {
    private static final Logger logger = Logger.getLogger(DefaultCheckpointHandler.class.getName());
    private static final File checkpointFile;

    public Checkpoint getCheckpoint(FlowContext flowContext) {
        return flowContext.getBean(Checkpoint.class);
    }

    public void storeCheckpoint(FlowContext flowContext) {
        Graph<Route, State> currentVertex;
        if (this.isEnabled() && (currentVertex = flowContext.getCurrentVertex()) != null) {
            Checkpoint checkpoint = flowContext.getBean(Checkpoint.class);
            if (checkpoint == null) {
                checkpoint = new Checkpoint();
                flowContext.addBean(checkpoint);
            }
            checkpoint.setLastStateId(currentVertex.getValue().getId());
            try {
                logger.log(Level.INFO, "Storing the session to {0}", checkpointFile);
                List beans = flowContext.getBeans();
                BeanStoreUtils.storeAsXML(checkpointFile, XmlBeanStoreFormat.DEFAULT, checkpointFile.getName(), beans.toArray());
                logger.log(Level.INFO, "Successfully stored the session to {0}", checkpointFile);
            }
            catch (BeanStoreException e) {
                logger.log(Level.WARNING, "Failed to store session to " + checkpointFile, e);
            }
        }
    }

    public boolean isCheckpointDataExist(FlowContext flowContext) {
        return checkpointFile.exists() && checkpointFile.isFile();
    }

    public void reset(FlowContext flowContext) {
        if (this.isCheckpointDataExist(flowContext)) {
            if (checkpointFile.delete()) {
                logger.log(Level.INFO, "Successfully deleted checkpoint file {0}", checkpointFile);
            } else {
                logger.log(Level.WARNING, "Failed to delete checkpoint file {0}", checkpointFile);
            }
        }
    }

    public void restoreCheckpoint(FlowContext flowContext) {
        try {
            logger.log(Level.INFO, "Restoring session from {0}", checkpointFile);
            String beanStoreName = checkpointFile.getName();
            Checkpoint checkpoint = BeanStoreUtils.restoreFromXML(checkpointFile, beanStoreName, Checkpoint.class);
            if (checkpoint != null) {
                flowContext.addBean(checkpoint);
                List<Class<? extends Object>> beanTypes = FlowBeanRegistry.getRegisteredBeanTypes();
                URL url = checkpointFile.toURL();
                List<?> beans = BeanStoreUtils.restoreAllFromXML(url, beanStoreName, beanTypes.toArray(new Class[0]));
                for (Object bean : beans) {
                    flowContext.addBean(bean);
                }
                logger.log(Level.INFO, "Successfully restored session from {0}", checkpointFile);
            } else {
                logger.log(Level.WARNING, "Unable to read checkpoint information from checkpoint file {0}", checkpointFile);
            }
        }
        catch (BeanStoreException e) {
            logger.log(Level.WARNING, "Failed to restore session from " + checkpointFile, e);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    static {
        String tmpdir = System.getProperty("java.io.tmpdir");
        checkpointFile = new File(tmpdir, "checkpoint");
    }
}

