/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.jewt;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.RoutePlanChangeEvent;
import oracle.install.commons.flow.RoutePlanChangeListener;
import oracle.install.commons.flow.State;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.Graph;
import oracle.install.commons.util.IconLibrary;

public class Billboard
extends JPanel
implements RoutePlanChangeListener,
ApplicationListener {
    private static final Logger logger = Logger.getLogger(Billboard.class.getName());
    private Graph<Route, State> currentVertex;
    private JLabel lblContent;
    private Color originalBgColor = this.getBackground();

    public Billboard() {
        this.lblContent = new JLabel();
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.lblContent, this, 0, 0, 1, 1, 0, 10, 1.0, 1.0, LayoutUtils.EMPTY_INSETS);
    }

    protected void updateContent() {
        URL billboardURL;
        this.setBackground(this.originalBgColor);
        State state = this.currentVertex.getValue();
        Application application = Application.getInstance();
        String billboardPath = application.getString(state.getId() + ".billboard", null, new Object[0]);
        if (billboardPath != null && (billboardURL = this.getClass().getResource(billboardPath)) != null) {
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(billboardURL);
                int color = bufferedImage.getRGB(0, 0);
                int r = (color & 0xFF0000) >> 16;
                int g = (color & 0xFF00) >> 8;
                int b = color & 0xFF;
                Color bgColor = new Color(r, g, b);
                this.setBackground(bgColor);
                ImageIcon imageIcon = IconLibrary.getInstance().getIcon(billboardURL);
                if (imageIcon != null) {
                    this.lblContent.setIcon(imageIcon);
                }
            }
            catch (Throwable e) {
                logger.log(Level.FINEST, String.format("Failed to load billboard image from %s", billboardURL), e);
            }
        }
    }

    public void stateChanged(RoutePlanChangeEvent e) {
        int eventId = e.getId();
        if ((eventId & 1) == 1) {
            RoutePlan routePlan = e.getSource();
            this.currentVertex = routePlan.getCurrentVertex();
            this.updateContent();
        }
    }

    public void update(ApplicationEvent e) {
        if (e.getType() == ApplicationEvent.Type.LOCALE_CHANGED) {
            this.updateContent();
        }
    }
}

