/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.jewt;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowDisplay;
import oracle.install.commons.flow.FlowNavigator;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.RoutePlanChangeEvent;
import oracle.install.commons.flow.RoutePlanChangeListener;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.jewt.FlowWizardPage;
import oracle.install.commons.util.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowWizard
extends Wizard
implements FlowDisplay,
RoutePlanChangeListener {
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private FlowNavigator flowNavigator;
    private List<WizardPage> pages;
    private WizardPage currentPage;
    private boolean jumping;
    private Runnable doNextTask = new Runnable(){

        public void run() {
            FlowWizard.this.jumping = false;
            FlowWizard.this.flowNavigator.goForward();
            FlowWizard.this.jumping = true;
        }
    };
    private Runnable doPreviousTask = new Runnable(){

        public void run() {
            FlowWizard.this.jumping = false;
            FlowWizard.this.flowNavigator.goBackward();
            FlowWizard.this.jumping = true;
        }
    };

    public FlowWizard() {
        this.pages = new ArrayList<WizardPage>();
    }

    @Override
    public void stateChanged(final RoutePlanChangeEvent changeEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.__updateRoadmap(changeEvent);
        } else {
            FutureTask<Void> updateRoadmapTask = new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    FlowWizard.this.__updateRoadmap(changeEvent);
                    return null;
                }
            });
            SwingUtilities.invokeLater(updateRoadmapTask);
            try {
                updateRoadmapTask.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void __updateRoadmap(RoutePlanChangeEvent changeEvent) {
        RoutePlan routePlan = changeEvent.getSource();
        int eventId = changeEvent.getId();
        State currentState = routePlan.getCurrentVertex().getValue();
        if (this.pages.isEmpty() && currentState.isViewState() || (eventId & 4) == 4) {
            if (routePlan.getTracedPath().isEmpty()) {
                return;
            }
            List<Graph<Route, State>> rolledBackPath = routePlan.getRolledBackPath();
            for (Graph<Route, State> vertex : rolledBackPath) {
                FlowWizardPage mappedPage = FlowWizardPage.getInstance(vertex);
                if (mappedPage == null) continue;
                this.pages.remove((Object)mappedPage);
                super.removePage((WizardPage)mappedPage);
                mappedPage.dispose();
            }
            List<Graph<Route, State>> tentativePath = routePlan.getTentativeTracedPath();
            for (Graph<Route, State> vertex : tentativePath) {
                if (FlowWizardPage.getInstance(vertex) != null) continue;
                FlowWizardPage wizardPage = FlowWizardPage.newBlankInstance(vertex);
                this.pages.add(wizardPage);
                super.addPage((WizardPage)wizardPage);
                switch (wizardPage.getType()) {
                    case 1: {
                        super.setProgressWizardPage((WizardPage)wizardPage);
                        break;
                    }
                    case 2: {
                        super.setEndOfProcessWizardPage((WizardPage)wizardPage);
                    }
                }
            }
        }
    }

    public WizardPage getCurrentPage() {
        return this.currentPage;
    }

    protected void doNext() {
        this.executorService.execute(this.doNextTask);
    }

    protected void doPrevious() {
        this.executorService.execute(this.doPreviousTask);
    }

    @Override
    public FlowNavigator getFlowNavigator() {
        return this.flowNavigator;
    }

    @Override
    public void setFlowNavigator(FlowNavigator flowNavigator) {
        this.flowNavigator = flowNavigator;
        RoutePlan routePlan = this.flowNavigator.getRoutePlan();
        routePlan.addRoutePlanChangeListener(this);
        this.removeAllPages();
        this.restart();
    }

    public int getCurrentPageIndex() {
        return Math.max(this.pages.indexOf(this.currentPage), 0);
    }

    public WizardPage getNextPage(WizardPage page) {
        WizardPage nextPage = null;
        int index = this.pages.indexOf(page);
        if (index != -1 && index < this.pages.size() - 1) {
            nextPage = this.pages.get(index + 1);
        }
        return nextPage;
    }

    public WizardPage getPageAt(int index) {
        WizardPage wizardPage = this.pages.get(index);
        if (wizardPage != null) {
            wizardPage.setEnabled(true);
        }
        return this.pages.get(index);
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public void restart() {
        this.jumping = false;
        this.flowNavigator.reset();
        this.jumping = true;
    }

    protected void selectPage(final WizardPage page, boolean doValidate) {
        if (this.jumping) {
            this.executorService.execute(new Runnable(){

                public void run() {
                    if (page != null) {
                        Graph<Route, State> selectedVertex = ((FlowWizardPage)page).getVertex();
                        FlowWizard.this.flowNavigator.moveTo(selectedVertex);
                    }
                }
            });
        } else {
            super.selectPage(page, doValidate);
        }
    }

    @Override
    public void display(FlowContext flowContext, Graph<Route, State> vertex) {
        State state = vertex.getValue();
        if (state != null) {
            View view = state.getView();
            FlowWizardPage wizardPage = FlowWizardPage.getInstance(vertex);
            if (wizardPage != null) {
                Component content = view.getView();
                wizardPage.setContent(content);
                this.currentPage = wizardPage;
                super.selectPage((WizardPage)wizardPage, false);
            }
        }
    }

    protected void doFinish() {
        super.doFinish();
        this.executorService.execute(this.doNextTask);
    }
}

