/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.jewt;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardFrame;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.GraphicalStatusControl;
import oracle.install.commons.util.HelpManager;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.exception.ExceptionManager;

public class FlowWizardFrame
extends WizardFrame {
    public FlowWizardFrame(final Wizard wizard) {
        super((BaseWizard)wizard);
        Application application = Application.getInstance();
        super.setTitle(application.getName());
        application.setStatusControl(new GraphicalStatusControl((JComponent)wizard));
        ImageIcon imageIcon = application.getIcon("application.logo", new Object[0]);
        if (imageIcon != null) {
            wizard.setLogoImage(imageIcon.getImage());
            wizard.setHeaderGradientBackground(new Color[]{this.getBackground(), Color.white});
        }
        if ((imageIcon = application.getIcon("application.icon", new Object[0])) != null) {
            this.setIconImage(imageIcon.getImage());
        }
        wizard.setRoadmapVisible(application.getBoolean("wizard.roadmapVisible", true));
        wizard.setHelpAvailable(application.getBoolean("wizard.helpAvailable", true));
        HelpUtils.setDefaultHelpProvider((HelpProvider)new HelpProvider(){

            public void showHelp(Component component) throws HelpUnavailableException {
                Application application = Application.getInstance();
                try {
                    HelpManager helpManager = application.getHelpManager();
                    helpManager.showHelpForComponent(component);
                }
                catch (Throwable e) {
                    ExceptionManager.report(e);
                }
            }
        });
        final ValidationMessagePane pane = new ValidationMessagePane(){

            protected String getComponentName(ValidationComponent validationComponent) {
                Component component;
                String name = super.getComponentName(validationComponent);
                if (name != null && (component = validationComponent.getComponent()) != null && name.equals(component.getName())) {
                    name = null;
                }
                return name;
            }
        };
        pane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (ValidationMessagePane.PANE_EMPTY.equals(e.getPropertyName())) {
                    if (pane.isEmpty()) {
                        wizard.setBottomContentMode(1);
                    } else {
                        wizard.setBottomContentMode(0);
                    }
                }
            }
        });
        wizard.setValidationMessagePane(pane);
        String sizeString = application.getString("wizard.size", "large", new Object[0]);
        int size = 1;
        if ("small".equals(sizeString)) {
            size = 0;
        }
        wizard.setDefaultWizardSize(size);
    }

    protected void dismissFrame(final boolean cancelled) {
        Application application = Application.getInstance();
        if (cancelled) {
            application.pause(true);
            String quitPrompt = application.getString(ResourceURL.resURL("oracle.install.commons.util.resource.StringResourceBundle", "application.prompt.close.confirmation"), "Do you really want to exit ?", new Object[0]);
            if (!StandardDialog.promptQuestion((Component)((Object)this), quitPrompt)) {
                application.pause(false);
                return;
            }
            application.pause(false);
        }
        application.addApplicationListener(new ApplicationListener(){

            public void update(ApplicationEvent e) {
                if (e.getType() == ApplicationEvent.Type.SHUTDOWN) {
                    FlowWizardFrame.super.dismissFrame(cancelled);
                }
            }
        });
        application.shutdown();
    }
}

