/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.jewt;

import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowControl;
import oracle.install.commons.flow.FlowDirection;
import oracle.install.commons.flow.FlowNavigator;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.Transition;
import oracle.install.commons.flow.jewt.FlowWizard;
import oracle.install.commons.util.Graph;

public class JewtFlowControl
implements FlowControl {
    private FlowWizard flowDisplay;
    private Runnable forward;
    private Runnable backward;
    private FlowContext flowContext;

    public JewtFlowControl(final FlowWizard flowDisplay, FlowContext flowContext) {
        this.flowContext = flowContext;
        this.flowDisplay = flowDisplay;
        this.forward = new Runnable(){

            public void run() {
                flowDisplay.doNext();
            }
        };
        this.backward = new Runnable(){

            public void run() {
                flowDisplay.doPrevious();
            }
        };
    }

    public void lock(FlowDirection direction, boolean enabled) {
        WizardPage currentPage = this.flowDisplay.getCurrentPage();
        switch (direction) {
            case FORWARD: {
                currentPage.setCanAdvance(!enabled);
                break;
            }
            case BACKWARD: {
                currentPage.setCanGoBack(!enabled);
                break;
            }
            case NONE: {
                this.lock(enabled);
            }
        }
    }

    public void backward() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.flowDisplay.doPrevious();
        } else {
            SwingUtilities.invokeLater(this.backward);
        }
    }

    public void forward() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.flowDisplay.doNext();
        } else {
            SwingUtilities.invokeLater(this.forward);
        }
    }

    public void stop() {
        Transition transition = this.flowContext.getTransition();
        if (transition != null) {
            transition.abort();
        }
    }

    public void lock(boolean enabled) {
        WizardPage currentPage = this.flowDisplay.getCurrentPage();
        RoutePlan routePlan = this.flowDisplay.getFlowNavigator().getRoutePlan();
        if (!routePlan.getCurrentVertex().isTerminal()) {
            currentPage.setCanAdvance(!enabled);
        }
        currentPage.setCanGoBack(!enabled);
    }

    public void lookAhead(Route route) {
        this.flowDisplay.getFlowNavigator().getRoutePlan().lookAhead(route);
    }

    public void markCurrentStateAsDirty(boolean dirty) {
        State state;
        Graph<Route, State> vertex;
        RoutePlan routePlan;
        FlowNavigator flowNavigator = this.flowDisplay.getFlowNavigator();
        if (flowNavigator != null && (routePlan = flowNavigator.getRoutePlan()) != null && (vertex = routePlan.getCurrentVertex()) != null && (state = vertex.getValue()) != null) {
            state.setDirty(dirty);
        }
    }
}

