/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.jewt;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.text.MessageFormat;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.RoutePlanChangeEvent;
import oracle.install.commons.flow.RoutePlanChangeListener;
import oracle.install.commons.flow.resource.StringResourceBundle;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

public class WizardTitleBarHandler
implements RoutePlanChangeListener {
    private Window window;
    private String wizardName;
    private String processName;
    private Resource resource;

    public WizardTitleBarHandler(Window window) {
        this(window, null, null);
    }

    public WizardTitleBarHandler(Window window, String wizardName, String processName) {
        this.window = window;
        Application application = Application.getInstance();
        if (wizardName == null) {
            wizardName = application.getString("wizard.titleBar.wizardName", "Wizard", new Object[0]);
        }
        if (processName == null) {
            processName = application.getString("wizard.titleBar.processName", "Processing", new Object[0]);
        }
        this.wizardName = wizardName;
        this.processName = processName;
        this.resource = application.getResource(StringResourceBundle.class.getName());
    }

    public void stateChanged(RoutePlanChangeEvent e) {
        int tentativeCurrentIndex;
        int eventId = e.getId();
        RoutePlan routePlan = e.getSource();
        if (((eventId & 4) == 4 || (eventId & 1) == 1) && (tentativeCurrentIndex = routePlan.getTentativeCurrentIndex()) >= 0) {
            try {
                int tentativeTracedPathLength = routePlan.getTentativeTracedPathLength();
                String titleFormat = this.resource.getString("wizard.titleBar.titleFormat", "{0} - {1} - Step {2} of {3}", new Object[0]);
                String title = MessageFormat.format(titleFormat, this.wizardName, this.processName, tentativeCurrentIndex + 1, tentativeTracedPathLength);
                if (this.window instanceof Dialog) {
                    ((Dialog)this.window).setTitle(title);
                } else if (this.window instanceof Frame) {
                    ((Frame)this.window).setTitle(title);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

