/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.validation;

import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.util.Console;
import oracle.install.commons.util.exception.ExceptionHandler;
import oracle.install.commons.util.exception.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleValidationExceptionHandler
implements ExceptionHandler<ValidationException> {
    @Override
    public void handleException(ValidationException e) {
        Severity severity = e.getSeverity();
        System.out.printf("[%s] %s\n", new Object[]{severity, e.getMessage()});
        if (severity == Severity.WARNING) {
            boolean stop = true;
            do {
                String input;
                if ("n".equalsIgnoreCase(input = Console.getInput("\nDo you want to continue ? ([Y]es or [N]o).(To view stacktrace enter [S])"))) {
                    System.exit(0);
                    continue;
                }
                if (!"s".equalsIgnoreCase(input)) continue;
                e.printStackTrace(System.out);
                Throwable cause = e.getCause();
                Console.println("Caused by the following Exception");
                cause.printStackTrace(System.out);
                stop = false;
            } while (!stop);
        } else if (severity == Severity.FATAL) {
            System.exit(0);
        }
    }
}

