/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.validation;

import java.util.Collection;
import java.util.logging.Logger;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.validation.BeanValidator;
import oracle.install.commons.flow.validation.BeanValidatorRegistry;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.DefaultValidationExceptionHandler;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.flow.validation.annotation.ValidateBean;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ExceptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationHelper {
    private static Logger logger = Logger.getLogger(ValidationHelper.class.getName());
    private static final ExceptionManager exceptionManager = ExceptionManager.getInstance();

    public static boolean validate(FlowContext flowContext, Validator validator) {
        boolean succeeded = true;
        try {
            validator.validate(flowContext);
        }
        catch (ValidationException e) {
            succeeded = false;
            exceptionManager.handleException(e);
        }
        return succeeded;
    }

    public static boolean validate(FlowContext flowContext, State state) {
        boolean succeeded = true;
        try {
            ValidationHelper.validateBeans(flowContext, state);
        }
        catch (ValidationException e) {
            succeeded = false;
            exceptionManager.handleException(e);
        }
        if (succeeded) {
            try {
                ValidationHelper.validateState(flowContext, state);
            }
            catch (ValidationException e) {
                succeeded = false;
                exceptionManager.handleException(e);
            }
        }
        return succeeded;
    }

    public static void validateBeans(FlowContext flowContext, State state) throws ValidationException {
        Action action = state.getAction();
        ValidateBean validateBean = action.getClass().getAnnotation(ValidateBean.class);
        if (validateBean != null) {
            String[] beanIds = validateBean.value();
            logger.info("Validate beans before move out from state:" + state.getId());
            if (beanIds != null) {
                logger.info("Validate values " + beanIds);
                for (String beanId : beanIds) {
                    Class<?> beanType;
                    BeanValidator beanValidator;
                    Object bean = flowContext.getBean(beanId);
                    if (bean == null || (beanValidator = BeanValidatorRegistry.getValidator(beanType = bean.getClass())) == null) continue;
                    beanValidator.validate(bean, new String[0]);
                }
            }
        } else {
            logger.info("Bean Validation rules not provided for state:" + state.getId());
        }
    }

    public static Validator getValidator(State state) {
        Validator validator = state.getValidator();
        if (validator == null) {
            Action action;
            ValidatorRef validatorDef;
            Class<Object> validatorClass = null;
            String validatorId = state.getValidatorId();
            if (validatorId != null) {
                try {
                    validatorClass = Class.forName(validatorId);
                }
                catch (Exception e) {
                    logger.warning("Failed to load validator " + validatorId + " configured to state " + state.getId() + ". Error: " + e.getMessage());
                }
            }
            if (validatorClass == null && (validatorDef = (action = state.getAction()).getClass().getAnnotation(ValidatorRef.class)) != null) {
                validatorClass = validatorDef.value();
                logger.info("Using default Validator configured in the Action " + action.getClass());
            }
            if (validatorClass != null) {
                try {
                    validator = (Validator)validatorClass.newInstance();
                    state.setValidator(validator);
                }
                catch (Exception e) {
                    logger.warning("Failed to load validator " + validatorClass);
                    state.setValidationRequired(false);
                    logger.warning("Validation disabled for the state " + state.getId());
                }
            } else {
                state.setValidationRequired(false);
                logger.warning("Validation disabled for the state " + state.getId());
            }
        }
        return validator;
    }

    public static StatusMessages<ValidationStatusMessage> validateView(FlowContext flowContext, State state) throws ValidationException {
        View view;
        StatusMessages<ValidationStatusMessage> messages = null;
        if (state.isViewState() && (view = state.getView()) instanceof Validator) {
            Validator validator = (Validator)((Object)view);
            validator.validate(flowContext);
            if (view instanceof CompositeValidator) {
                messages = ((CompositeValidator)validator).getValidationStatusMessages();
            }
        }
        return messages;
    }

    public static StatusMessages<ValidationStatusMessage> validateState(FlowContext flowContext, State state) throws ValidationException {
        Validator validator;
        StatusMessages<ValidationStatusMessage> messages = null;
        if (state.isValidationRequired() && (validator = ValidationHelper.getValidator(state)) != null) {
            validator.validate(flowContext);
            if (validator instanceof CompositeValidator) {
                StatusMessages<ValidationStatusMessage> m = ((CompositeValidator)validator).getValidationStatusMessages();
                if (messages != null) {
                    messages.addAll((Collection<ValidationStatusMessage>)m);
                } else {
                    messages = m;
                }
            }
        }
        return messages;
    }

    static {
        exceptionManager.addExceptionHandler(ValidationException.class, new DefaultValidationExceptionHandler());
    }
}

