/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.net.support;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSHConnectivityDetails {
    private Set<String> unconfiguredNodes = new TreeSet<String>();
    private Set<String> configuredNodes = new TreeSet<String>();
    private String sharedUserName;
    private Map<String, StatusMessages<StatusMessage>> statusMessagesMap = new TreeMap<String, StatusMessages<StatusMessage>>();
    private StatusMessage overallStatusMessage;

    public StatusMessage getOverallStatusMessage() {
        return this.overallStatusMessage;
    }

    public void setOverallStatusMessage(StatusMessage overallStatusMessage) {
        this.overallStatusMessage = overallStatusMessage;
    }

    public ErrorMessage getOverallErrorMessage() {
        return this.overallStatusMessage instanceof ErrorMessage ? (ErrorMessage)this.overallStatusMessage : null;
    }

    public Set<String> getUnconfiguredNodes() {
        return this.unconfiguredNodes;
    }

    public void setUnconfiguredNodes(Set<String> unconfiguredNodes) {
        if (unconfiguredNodes == null) {
            unconfiguredNodes = new TreeSet<String>();
        } else {
            this.unconfiguredNodes.clear();
        }
        this.unconfiguredNodes = unconfiguredNodes;
        this.configuredNodes.removeAll(unconfiguredNodes);
    }

    public Set<String> getConfiguredNodes() {
        return this.configuredNodes;
    }

    public void setConfiguredNodes(Set<String> configuredNodes) {
        if (configuredNodes == null) {
            configuredNodes = new TreeSet<String>();
        } else {
            this.configuredNodes.clear();
        }
        this.configuredNodes = configuredNodes;
        this.unconfiguredNodes.removeAll(configuredNodes);
    }

    public String getSharedUserName() {
        return this.sharedUserName;
    }

    public void setSharedUserName(String sharedUserName) {
        this.sharedUserName = sharedUserName;
    }

    public Map<String, StatusMessages<StatusMessage>> getStatusMessagesMap() {
        return this.statusMessagesMap;
    }

    public void setStatusMessagesMap(Map<String, StatusMessages<StatusMessage>> statusMessagesMap) {
        if (statusMessagesMap == null) {
            statusMessagesMap = new TreeMap<String, StatusMessages<StatusMessage>>();
        } else if (this.statusMessagesMap != null) {
            for (Map.Entry<String, StatusMessages<StatusMessage>> e : this.statusMessagesMap.entrySet()) {
                StatusMessages<StatusMessage> value = e.getValue();
                if (value == null) continue;
                value.clear();
            }
            this.statusMessagesMap.clear();
        }
        this.statusMessagesMap = statusMessagesMap;
    }

    public boolean isConfigurationComplete() {
        return this.unconfiguredNodes.isEmpty() && !this.configuredNodes.isEmpty();
    }

    public boolean isNodeConfigured(String node) {
        return this.configuredNodes.contains(node);
    }

    public StatusMessages<StatusMessage> setStatusMessages(String node, StatusMessages<StatusMessage> statusMessages) {
        return this.statusMessagesMap.put(node, statusMessages);
    }

    public boolean setStatusMessage(String node, StatusMessage statusMessage) {
        StatusMessages<StatusMessage> messages = this.getStatusMessages(node);
        messages.clear();
        return messages.add(statusMessage);
    }

    public boolean addStatusMessage(String node, StatusMessage statusMessage) {
        StatusMessages<StatusMessage> messages = this.getStatusMessages(node);
        return messages.add(statusMessage);
    }

    public boolean removeStatusMessage(String node, StatusMessage statusMessage) {
        StatusMessages<StatusMessage> messages = this.getStatusMessages(node);
        return messages.remove(statusMessage);
    }

    public StatusMessages<StatusMessage> getStatusMessages(String node) {
        StatusMessages<StatusMessage> statusMessages = this.statusMessagesMap.get(node);
        if (statusMessages == null) {
            statusMessages = new StatusMessages();
            this.statusMessagesMap.put(node, statusMessages);
        }
        return statusMessages;
    }

    public void setUnconfiguredNodes(String[] nodes) {
        if (nodes != null && nodes.length > 0) {
            TreeSet<String> nodeSet = new TreeSet<String>();
            nodeSet.addAll(Arrays.asList(nodes));
            this.setUnconfiguredNodes(nodeSet);
        }
    }

    public void setConfiguredNodes(String[] nodes) {
        if (nodes != null && nodes.length > 0) {
            this.getConfiguredNodes().addAll(Arrays.asList(nodes));
        }
    }
}

