/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public abstract class AbstractIcon
extends ImageIcon {
    protected RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    protected Color border;
    protected Color shadowBorder;
    protected int iconWidth;
    protected int iconHeight;
    private BufferedImage image;
    boolean painted;
    private boolean transparent;

    public AbstractIcon() {
        this(9, 9, false);
    }

    public AbstractIcon(int iconWidth, int iconHeight, boolean transparent) {
        this.renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.transparent = transparent;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.border = new Color(153, 153, 153);
        this.shadowBorder = new Color(204, 204, 204);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        this.image = gc.createCompatibleImage(this.iconWidth, this.iconHeight, 3);
    }

    public Image getImage() {
        return this.image;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public void setIconHeight(int height) {
        this.iconHeight = height;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public void setIconWidth(int width) {
        this.iconWidth = width;
    }

    public Color getBorder() {
        return this.border;
    }

    public void setBorder(Color border) {
        this.border = border;
    }

    public Color getShadowBorder() {
        return this.shadowBorder;
    }

    public void setShadowBorder(Color shadowBorder) {
        this.shadowBorder = shadowBorder;
    }

    public final synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        if (!this.painted) {
            Graphics2D g2 = (Graphics2D)this.image.getGraphics();
            g2.setRenderingHints(this.renderHints);
            if (!this.transparent) {
                g2.setColor(Color.white);
                g2.fillRect(0, 0, this.iconWidth - 1, this.iconHeight - 1);
                g2.setColor(this.border);
                g2.drawRect(0, 0, this.iconWidth - 1, this.iconHeight - 1);
                g2.setColor(this.shadowBorder);
                g2.drawLine(1, this.iconHeight - 2, this.iconWidth - 2, this.iconHeight - 2);
            }
            this.paintIcon(c, g2, 0, 0, this.iconWidth - 1, this.iconHeight - 1);
            this.painted = true;
        }
        g.drawImage(this.image, x, y, this.iconWidth, this.iconHeight, c);
    }

    public abstract void paintIcon(Component var1, Graphics2D var2, int var3, int var4, int var5, int var6);
}

