/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Banner
extends JPanel {
    private static Dimension BANNER_SIZE = new Dimension(100, 62);
    private HeaderLabel headerLabel;

    public Banner() {
        this.buildUI();
    }

    public void setText(String text) {
        this.headerLabel.setText(text);
    }

    public void setIcon(Icon icon) {
        this.headerLabel.setLogo(icon);
    }

    protected void buildUI() {
        this.headerLabel = new HeaderLabel();
        this.setLayout(new BorderLayout());
        this.add(this.headerLabel);
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.headerLabel != null) {
            this.headerLabel.setBackground(bg);
        }
    }

    public Dimension getPreferredSize() {
        return BANNER_SIZE;
    }

    public Dimension getMaximumSize() {
        return BANNER_SIZE;
    }

    public Dimension getMinimumSize() {
        return BANNER_SIZE;
    }

    private static class HeaderLogo
    extends JLabel {
        private HeaderLogo() {
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            this.setVisible(this.getIcon() != null);
        }
    }

    private static class HeaderLabel
    extends JLabel {
        private HeaderLogo headerLogo;
        private CellRendererPane cellRendererPane;
        private RenderingHints renderHints;
        private boolean _doInit = true;

        public HeaderLabel() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
            this.headerLogo = new HeaderLogo();
            this.cellRendererPane = new CellRendererPane();
            this.renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }

        public void setLogo(Icon icon) {
            this.headerLogo.setIcon(icon);
        }

        public void addNotify() {
            super.addNotify();
            if (this._doInit) {
                this._doInit = false;
                Font f = this.getFont();
                this.setFont(new Font(f.getName(), f.getStyle() | 1, (int)((double)f.getSize() * 1.3)));
            }
        }

        public void paintComponent(Graphics g) {
            int width;
            Graphics2D g2 = (Graphics2D)g;
            int gw = width = this.getWidth();
            Icon icon = this.headerLogo.getIcon();
            if (icon != null) {
                Rectangle area = new Rectangle();
                area.x = (gw -= icon.getIconWidth()) + 1;
                area.y = 0;
                area.width = icon.getIconWidth();
                area.height = this.getHeight();
                this.cellRendererPane.paintComponent(g2, this.headerLogo, this, area);
            }
            g2.setRenderingHints(this.renderHints);
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.white, gw, 0.0f, this.getBackground());
            g2.setPaint(gradientPaint);
            g.fillRect(0, 0, gw, this.getHeight());
            super.paintComponent(g);
        }
    }
}

