/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Dialog;
import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.install.commons.flow.validation.UncheckedValidationException;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.swing.MessageDialog;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.BaseException;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ErrorMessageHelper;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.ContentHelper;
import oracle.install.commons.util.resource.StringResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorDialog
extends MessageDialog {
    private static final Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
    private static final String FMT_CAUSE_ACTION = "<b>%s</b>&nbsp;-&nbsp;%s<br><br>";

    public ErrorDialog(Frame owner) {
        super(owner);
    }

    public ErrorDialog(Dialog owner) {
        super(owner);
    }

    @Override
    protected void buildUI() {
        super.buildUI();
        this.txpDetails.addHyperlinkListener(ErrorMessageHelper.getSharedErrorCodeHyperLinkListener());
    }

    @Override
    protected String getDetails(StatusMessage statusMessage) {
        StringBuffer detailsBuffer = new StringBuffer();
        if (statusMessage != null && statusMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)statusMessage;
            ErrorInfo errorInfo = errorMessage.getErrorInfo();
            detailsBuffer.append(this.getDetails(errorInfo));
            Throwable cause = errorMessage.getCause();
            if (cause != null) {
                detailsBuffer.append(this.getStacktraceDetails(cause));
            }
            detailsBuffer.append(this.getExtraDetails(errorInfo));
        }
        return detailsBuffer.toString();
    }

    private String getExtraDetails(ErrorInfo errorInfo) {
        String content;
        Content extraDetails;
        StringBuffer detailsBuffer = new StringBuffer();
        if (errorInfo != null && (extraDetails = errorInfo.getExtraDetails()) != null && (content = ContentHelper.getContentAsHTML(extraDetails)) != null && content.trim().length() > 0) {
            String title = extraDetails.getTitle();
            title = title == null || title.trim().length() == 0 ? resource.getString("ErrorMessage.details.titles.extraDetails", "More Details", new Object[0]) : title;
            detailsBuffer.append("<b>").append(title).append("</b>");
            detailsBuffer.append("<pre>");
            detailsBuffer.append(content);
            detailsBuffer.append("</pre>");
            detailsBuffer.append("<br>");
        }
        return detailsBuffer.toString();
    }

    private String getDetails(ErrorInfo errorInfo) {
        StringBuffer detailsBuffer = new StringBuffer();
        if (errorInfo != null) {
            String cause = errorInfo.getCause();
            String action = errorInfo.getAction();
            if (cause != null && cause.trim().length() > 0) {
                detailsBuffer.append(String.format(FMT_CAUSE_ACTION, resource.getString("ErrorMessage.details.titles.cause", "Cause", new Object[0]), cause));
            }
            if (action != null && action.trim().length() > 0) {
                detailsBuffer.append(String.format(FMT_CAUSE_ACTION, resource.getString("ErrorMessage.details.titles.action", "Action", new Object[0]), action));
            }
        }
        return detailsBuffer.toString();
    }

    protected String getStacktraceDetails(Throwable throwable) {
        String details = "";
        if (throwable != null && !(throwable instanceof ValidationException) && !(throwable instanceof UncheckedValidationException)) {
            String title;
            StringBuffer detailsBuffer = new StringBuffer();
            ArrayList<String> causes = new ArrayList<String>();
            ExceptionManager.enumCauses(throwable, causes);
            if (!causes.isEmpty()) {
                title = resource.getString("ErrorMessage.details.titles.stackSummary", "Summary", new Object[0]);
                detailsBuffer.append("<b>");
                detailsBuffer.append(title);
                detailsBuffer.append("</b>");
                for (String cause : causes) {
                    detailsBuffer.append("<br>");
                    detailsBuffer.append("&nbsp;-&nbsp;");
                    detailsBuffer.append(cause);
                }
                detailsBuffer.append("<br>");
                detailsBuffer.append("<br>");
            }
            if (Application.getInstance().getLogLevel() == Level.FINEST) {
                StringWriter out = new StringWriter();
                throwable.printStackTrace(new PrintWriter(out));
                title = resource.getString("ErrorMessage.details.titles.stackDetails", "Stacktrace", new Object[0]);
                detailsBuffer.append("<b>");
                detailsBuffer.append(title);
                detailsBuffer.append("</b><pre>");
                detailsBuffer.append(out.toString());
                detailsBuffer.append("</pre>");
            }
            details = ErrorMessageHelper.formatMessage(throwable, detailsBuffer.toString());
        }
        return details;
    }

    @Override
    protected void prepareOptionPane(Level level, boolean detailsAvailable, Option defaultOption, Option ... options) {
        String message = null;
        if (level == Level.SEVERE) {
            this.txaConfirm.setVisible(false);
        } else if (level == Level.WARNING) {
            message = resource.getString("prompt.warning.confirmation", "Are you sure you want to continue ?", new Object[0]);
            this.txaConfirm.setText(message);
            this.txaConfirm.setVisible(true);
        }
        super.prepareOptionPane(level, detailsAvailable, defaultOption, options);
    }

    public Advice advise(String title, ErrorMessage errorMessage) {
        String hint;
        StatusMessages<ErrorMessage> statusMessages = new StatusMessages<ErrorMessage>();
        statusMessages.add(errorMessage);
        ErrorInfo errorInfo = errorMessage.getErrorInfo();
        if (errorInfo != null && (hint = errorInfo.getHint()) != null) {
            title = hint;
        }
        Advice advice = this.advise(title, statusMessages);
        statusMessages.clear();
        return advice;
    }

    public Advice advise(String title, StatusMessages<? extends ErrorMessage> errorMessages) {
        Advice advice = Advice.NONE;
        if (errorMessages != null && !errorMessages.isEmpty()) {
            Level level = errorMessages.getAggregateLevel();
            Severity severity = ExceptionManager.getSeverity(level);
            Option[] options = null;
            MessageDialog.CommonOption defaultOption = null;
            switch (severity) {
                case WARNING: {
                    options = MessageDialog.OPTIONS_YES_NO;
                    defaultOption = MessageDialog.CommonOption.NO;
                    break;
                }
                default: {
                    options = MessageDialog.OPTIONS_OK;
                    defaultOption = MessageDialog.CommonOption.OK;
                }
            }
            MessageDialog.CommonOption option = (MessageDialog.CommonOption)super.show(title, errorMessages, (Option)defaultOption, options);
            advice = this.advise(severity, option);
        }
        return advice;
    }

    @Deprecated
    public Advice advise(Throwable throwable, Severity severity, ErrorCode errorCode, String hint, String message) {
        Content content;
        DefaultErrorMessage errorMessage = new DefaultErrorMessage(throwable, errorCode, severity, new Object[0]);
        if (message != null) {
            errorMessage.setMessage(message);
        }
        ErrorInfo errorInfo = errorMessage.getErrorInfo();
        if (throwable instanceof BaseException && (content = ((BaseException)((Object)throwable)).getErrorInfo().getExtraDetails()) != null) {
            errorMessage.getErrorInfo().setExtraDetails(content);
        }
        if (errorInfo != null) {
            errorInfo.setHint(hint);
        }
        if (severity == Severity.FATAL) {
            String confirmation = resource.getString("prompt.fatal.confirmation", "The application is unstable, closing application.", new Object[0]);
            this.txaConfirm.setText(confirmation);
            this.txaConfirm.setVisible(true);
        }
        return this.advise(null, errorMessage);
    }

    public Advice advise(String title, ErrorCode errorCode, Object ... messageArgs) {
        DefaultErrorMessage errorMessage = new DefaultErrorMessage(errorCode, messageArgs);
        StatusMessages<DefaultErrorMessage> errors = new StatusMessages<DefaultErrorMessage>();
        errors.add(errorMessage);
        return this.advise(title, errors);
    }

    public Advice advise(String title, Throwable e) {
        DefaultErrorMessage errorMessage = new DefaultErrorMessage(e);
        StatusMessages<DefaultErrorMessage> errors = new StatusMessages<DefaultErrorMessage>();
        errors.add(errorMessage);
        title = title == null ? Application.getInstance().getName() : title;
        return this.advise(title, errors);
    }

    protected Advice advise(Severity severity, MessageDialog.CommonOption option) {
        Advice advice = Advice.NONE;
        switch (option) {
            case YES: {
                advice = Advice.CONTINUE;
                break;
            }
            case OK: {
                advice = severity == Severity.FATAL ? Advice.ABORT : Advice.NONE;
                break;
            }
            case NO: {
                advice = Advice.WITHDRAW;
            }
        }
        return advice;
    }
}

