/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class Glasspane
extends JPanel {
    public static int STATUS = JLayeredPane.MODAL_LAYER;
    public static int BOTTOM_MOST = JLayeredPane.DEFAULT_LAYER;
    public static int TOP_MOST = JLayeredPane.DRAG_LAYER;
    private int zOrder = JLayeredPane.PALETTE_LAYER;
    private JLayeredPane layeredPane = new JLayeredPane();
    private int visibleComponentCount = 0;
    private ComponentListener visibilityMonitor;
    private CursorMonitor cursorMonitor;

    public static Glasspane getInstance(Window window) {
        RootPaneContainer rootPaneContainer = null;
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Glasspane is supported only for Java Swing components");
        }
        rootPaneContainer = (RootPaneContainer)((Object)window);
        return Glasspane.getInstance(rootPaneContainer);
    }

    public static Glasspane getInstance(JComponent component) {
        Window window = SwingUtilities.windowForComponent(component);
        return Glasspane.getInstance(window);
    }

    public static synchronized Glasspane getInstance(RootPaneContainer rootPaneContainer) {
        Glasspane instance = null;
        Component glasspane = rootPaneContainer.getGlassPane();
        if (!(glasspane instanceof Glasspane)) {
            instance = new Glasspane();
            rootPaneContainer.setGlassPane(instance);
            instance.setVisible(false);
        } else {
            instance = (Glasspane)glasspane;
        }
        return instance;
    }

    private Glasspane() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add(this.layeredPane);
        this.visibilityMonitor = new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                --Glasspane.this.visibleComponentCount;
                if (Glasspane.this.visibleComponentCount == 0) {
                    Glasspane.this.setVisible(false);
                }
            }

            public void componentShown(ComponentEvent e) {
                ++Glasspane.this.visibleComponentCount;
                if (Glasspane.this.visibleComponentCount > 0) {
                    Glasspane.this.setVisible(true);
                }
            }
        };
        this.layeredPane.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                Component glassLayer = e.getChild();
                glassLayer.addComponentListener(Glasspane.this.visibilityMonitor);
                if (glassLayer.isVisible()) {
                    Glasspane.this.visibleComponentCount++;
                    Glasspane.this.setVisible(true);
                }
                Glasspane.this.addComponentListener(new ComponentResizer(glassLayer));
            }

            public void componentRemoved(ContainerEvent e) {
                ComponentListener[] listeners;
                Component component = e.getComponent();
                component.removeComponentListener(Glasspane.this.visibilityMonitor);
                --Glasspane.this.visibleComponentCount;
                if (Glasspane.this.visibleComponentCount == 0) {
                    Glasspane.this.setVisible(false);
                }
                for (ComponentListener cl : listeners = Glasspane.this.getComponentListeners()) {
                    ComponentResizer resizer;
                    if (!(cl instanceof ComponentResizer) || (resizer = (ComponentResizer)cl).getComponent() != component) continue;
                    Glasspane.this.removeComponentListener(cl);
                }
            }
        });
        this.cursorMonitor = new CursorMonitor();
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(Glasspane.this.cursorMonitor);
            }

            public void componentShown(ComponentEvent e) {
                Toolkit.getDefaultToolkit().addAWTEventListener(Glasspane.this.cursorMonitor, 131121L);
            }
        });
    }

    public void moveToFront(JComponent component) {
        this.layeredPane.moveToFront(component);
    }

    public void moveToBack(JComponent component) {
        this.layeredPane.moveToBack(component);
    }

    public void addLayer(JComponent component, int zOrder) {
        Dimension size = this.getParent().getSize();
        component.setBounds(0, 0, size.width, size.height);
        this.layeredPane.add((Component)component, zOrder);
        this.layeredPane.setLayer(component, zOrder);
    }

    private int getZOrder() {
        int index = this.zOrder++;
        if (this.zOrder == JLayeredPane.MODAL_LAYER) {
            this.zOrder = JLayeredPane.PALETTE_LAYER;
        }
        return index;
    }

    public int addLayer(JComponent component) {
        int zOrder = this.getZOrder();
        this.addLayer(component, zOrder);
        return zOrder;
    }

    public JComponent getLayer(int zOrder) {
        Component[] comps = this.layeredPane.getComponentsInLayer(zOrder);
        if (comps == null || comps.length <= 0) {
            return null;
        }
        return (JComponent)comps[0];
    }

    private class CursorMonitor
    implements AWTEventListener {
        private CursorMonitor() {
        }

        public void eventDispatched(AWTEvent e) {
            Object source = e.getSource();
            if (source instanceof Component) {
                Cursor cursor = ((Component)source).getCursor();
                Glasspane.this.setCursor(cursor);
            }
        }
    }

    private class ComponentResizer
    extends ComponentAdapter {
        private Component component;

        public ComponentResizer(Component component) {
            this.component = component;
        }

        public Component getComponent() {
            return this.component;
        }

        public void componentResized(ComponentEvent e) {
            Dimension size = e.getComponent().getParent().getSize();
            this.component.setBounds(0, 0, size.width, size.height);
        }
    }
}

