/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

class LazyTextChangeListenerThread
implements Runnable,
FocusListener,
DocumentListener {
    private static final String CLIENT_PROPERTY_KEY = "oracle.install.commons.swing.LazyTextChangeListenerThread";
    private boolean alive;
    private JTextComponent txtComponent;
    private List<ChangeListener> changeListeners;
    private Object lock = new Object();
    private boolean sleeping;
    private int count;
    private boolean modified;
    private static final int WAIT_COUNT = 20;
    private static final int THREAD_SLEEP_TIME = 50;

    public static LazyTextChangeListenerThread getInstance(JTextComponent txtComponent) {
        Object value = txtComponent.getClientProperty(CLIENT_PROPERTY_KEY);
        LazyTextChangeListenerThread instance = null;
        if (value instanceof LazyTextChangeListenerThread) {
            instance = (LazyTextChangeListenerThread)value;
        } else {
            instance = new LazyTextChangeListenerThread();
            instance.attach(txtComponent);
        }
        return instance;
    }

    public LazyTextChangeListenerThread() {
        this.changeListeners = new ArrayList<ChangeListener>();
    }

    public void detach() {
        this.txtComponent = null;
        this.txtComponent.putClientProperty(CLIENT_PROPERTY_KEY, "");
    }

    public void attach(JTextComponent txtComp) {
        this.txtComponent = txtComp;
        this.txtComponent.addFocusListener(this);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
        if (this.changeListeners.isEmpty()) {
            this.txtComponent.removeFocusListener(this);
        }
    }

    private void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this.txtComponent);
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }

    private void listen() {
        this.count = 0;
        this.alive = true;
        this.modified = false;
        this.sleeping = false;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void focusGained(FocusEvent e) {
        this.listen();
    }

    public void focusLost(FocusEvent e) {
        this.alive = false;
        if (this.modified) {
            this.fireChangeEvent();
        }
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.sleeping = true;
                this.lock.wait(50L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.sleeping = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup() {
        if (this.sleeping) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }

    public void run() {
        Document document = this.txtComponent.getDocument();
        document.addDocumentListener(this);
        while (this.alive) {
            if (this.modified && this.count == 20) {
                this.fireChangeEvent();
                this.count = 0;
                this.modified = false;
            }
            ++this.count;
            this.sleep();
        }
        document.removeDocumentListener(this);
    }

    private void modified() {
        this.count = 0;
        this.modified = true;
    }

    public void changedUpdate(DocumentEvent e) {
        this.modified();
    }

    public void insertUpdate(DocumentEvent e) {
        this.modified();
    }

    public void removeUpdate(DocumentEvent e) {
        this.modified();
    }
}

