/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.install.commons.swing.HtmlPane;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.MultilineList;
import oracle.install.commons.swing.MultilineTableCellRenderer;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.DefaultStatusMessage;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDialog
extends JDialog {
    protected static final Resource resource = Application.getInstance().getResource("oracle.install.commons.swing.resource.SwingResourceBundle");
    public static final Option[] OPTIONS_YES_NO = new Option[]{CommonOption.YES, CommonOption.NO};
    public static final Option[] OPTIONS_YES_NO_CANCEL = new Option[]{CommonOption.YES, CommonOption.NO, CommonOption.CANCEL};
    public static final Option[] OPTIONS_OK_CANCEL = new Option[]{CommonOption.OK, CommonOption.CANCEL};
    public static final Option[] OPTIONS_OK = new Option[]{CommonOption.OK};
    private static final Dimension DEFAULT_MULTIMODE_MESSAGE_SIZE = new Dimension(400, 120);
    private static final Dimension DEFAULT_UNIMODE_MESSAGE_SIZE = new Dimension(400, 120);
    private static final Dimension DEFAULT_DETAILS_SIZE = new Dimension(400, 150);
    private static final String FMT_DETAILS = "<html><body>%s</body></html>";
    protected Option[] options;
    protected Option defaultOption;
    protected StatusMessages<? extends StatusMessage> statusMessages;
    protected boolean detailsAvailable;
    protected boolean multiMessageMode;
    protected MultilineList<StatusMessage> lstStatusMessages;
    protected JOptionPane optionPane;
    protected JPanel pnlMessage;
    protected MultilineLabel txaConfirm;
    protected MultilineLabel txaMessage;
    protected JScrollPane multimodeMessagePane;
    protected JScrollPane unimodeMessagePane;
    protected OptionButton defaultButton;
    protected JToggleButton btnDetails;
    protected HtmlPane txpDetails;
    protected JScrollPane detailsPane;

    public MessageDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public MessageDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    protected void init() {
        Application application = Application.getInstance();
        application.addApplicationListener(new ApplicationListener(){

            public void update(ApplicationEvent e) {
                if (e.getType() == ApplicationEvent.Type.LOCALE_CHANGED) {
                    MessageDialog.this.localize();
                }
            }
        });
        this.buildUI();
    }

    protected void localize() {
        String text = resource.getString("MessageDialog.btnDetails.text", "&Details*", new Object[0]);
        SwingUtils.setText(this.btnDetails, text);
    }

    protected void buildUI() {
        super.setModal(true);
        super.setResizable(false);
        this.txpDetails = new HtmlPane();
        this.txpDetails.setOpaque(false);
        this.txpDetails.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                AccessibleContext accessibleContext = e.getComponent().getAccessibleContext();
                if (accessibleContext != null) {
                    String description = resource.getString("MessageDialog.txpDetails.onFocusGained.accessibleDescription", "Use arrow keys to go through the details.", new Object[0]);
                    accessibleContext.setAccessibleDescription(description);
                }
            }
        });
        this.detailsPane = new JScrollPane(this.txpDetails);
        this.detailsPane.setPreferredSize(DEFAULT_DETAILS_SIZE);
        this.detailsPane.setVisible(false);
        this.lstStatusMessages = new MultilineList();
        this.lstStatusMessages.setName("MessageDialog.lstStatus");
        this.lstStatusMessages.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                StatusMessage statusMessage = (StatusMessage)MessageDialog.this.lstStatusMessages.getSelectedValue();
                String details = MessageDialog.this.getDetails(statusMessage);
                MessageDialog.this.populateDetails(details);
            }
        });
        this.lstStatusMessages.setCellRenderer(new MultilineTableCellRenderer<StatusMessage>(){

            @Override
            public String getText(StatusMessage value) {
                return value != null ? value.getMessage() : "";
            }
        });
        this.lstStatusMessages.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 67 && (e.getModifiers() & 2) == 2 && (e.getModifiers() & 1) != 1) {
                    Object[] items = MessageDialog.this.lstStatusMessages.getSelectedValues();
                    StringBuffer buffer = new StringBuffer();
                    for (Object item : items) {
                        StatusMessage m = (StatusMessage)item;
                        buffer.append(m.getMessage());
                        buffer.append('\n');
                    }
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection selection = new StringSelection(buffer.toString());
                    clipboard.setContents(selection, selection);
                }
            }
        });
        this.txaConfirm = new MultilineLabel();
        this.txaConfirm.setFocusable(true);
        this.btnDetails = new JToggleButton(){

            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleDetailsButton();
                }
                return this.accessibleContext;
            }

            class AccessibleDetailsButton
            extends JToggleButton.AccessibleJToggleButton {
                public AccessibleDetailsButton() {
                    super(this);
                    this.addFocusListener(new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            String description = null;
                            description = !this.isSelected() ? resource.getString("MessageDialog.btnDetails.onFocusGained.selected.accessibleDescription", "Press SPACEBAR to expand details section.", new Object[0]) : resource.getString("MessageDialog.btnDetails.onFocusGained.notSelected.accessibleDescription", "Press SPACEBAR to collapse details section.", new Object[0]);
                            AccessibleDetailsButton.this.setAccessibleDescription(description);
                        }
                    });
                }

                public void itemStateChanged(ItemEvent e) {
                    super.itemStateChanged(e);
                    String description = null;
                    description = e.getStateChange() == 1 ? resource.getString("MessageDialog.btnDetails.onItemStateChanged.selected.accessibleDescription", "Details section expanded. Press TAB to go to details section.", new Object[0]) : resource.getString("MessageDialog.btnDetails.onItemStateChanged.notSelected.accessibleDescription", "Details section collapsed.", new Object[0]);
                    super.setAccessibleDescription(description);
                }
            }
        };
        this.btnDetails.setName("MessageDialog.btnDetails");
        this.btnDetails.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (MessageDialog.this.multiMessageMode && MessageDialog.this.lstStatusMessages.getSelectedValue() == null) {
                    MessageDialog.this.lstStatusMessages.setSelectedIndex(0);
                }
                boolean selected = e.getStateChange() == 1;
                MessageDialog.this.detailsPane.setVisible(selected);
                MessageDialog.this.pack();
            }
        });
        this.optionPane = new JOptionPane();
        this.txaMessage = new MultilineLabel();
        this.txaMessage.setOpaque(false);
        this.txaMessage.setFocusable(true);
        this.multimodeMessagePane = new JScrollPane(this.lstStatusMessages);
        this.multimodeMessagePane.setPreferredSize(DEFAULT_MULTIMODE_MESSAGE_SIZE);
        this.unimodeMessagePane = new JScrollPane(this.txaMessage);
        this.unimodeMessagePane.setPreferredSize(DEFAULT_UNIMODE_MESSAGE_SIZE);
        this.pnlMessage = new JPanel();
        this.pnlMessage.setLayout(new GridBagLayout());
        this.optionPane.setMessage(this.pnlMessage);
        JPanel pnlMain = new JPanel();
        pnlMain.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.optionPane, pnlMain, 0, 0, 1, 1, 1, 18, 1.0, 1.0, LayoutUtils.EMPTY_INSETS);
        LayoutUtils.addComponent(this.detailsPane, pnlMain, 0, 1, 1, 1, 2, 18, 1.0, 0.0, LayoutUtils.EMPTY_INSETS);
        this.localize();
        this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (MessageDialog.this.isVisible() && event.getSource() == MessageDialog.this.optionPane && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    MessageDialog.this.setVisible(false);
                }
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)pnlMain, "Center");
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            public void windowClosing(WindowEvent we) {
                MessageDialog.this.optionPane.setValue(null);
                MessageDialog.this.dispose();
            }

            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    MessageDialog.this.optionPane.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        this.addWindowListener(adapter);
        this.addWindowFocusListener(adapter);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent ce) {
                MessageDialog.this.optionPane.setValue(null);
                if (MessageDialog.this.defaultButton != null) {
                    MessageDialog.this.defaultButton.grabFocus();
                }
            }
        });
        SwingUtils.setGenericFocusTraversalEnabled(this.txpDetails, true);
    }

    protected String getDetails(StatusMessage statusMessage) {
        return null;
    }

    private int styleFromMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    protected void rebuildUI() {
        boolean supportsWindowDecorations;
        int n;
        if (this.statusMessages == null || this.statusMessages.isEmpty()) {
            return;
        }
        if (this.statusMessages.size() > 1) {
            this.multiMessageMode = true;
            this.statusMessages.sortByLevel();
            this.lstStatusMessages.clear();
            for (StatusMessage statusMessage : this.statusMessages) {
                this.lstStatusMessages.addItem(statusMessage);
            }
        } else {
            StatusMessage firstMessage = (StatusMessage)this.statusMessages.get(0);
            this.txaMessage.setText(firstMessage.getMessage());
            this.txaMessage.setCaretPosition(0);
        }
        String firstMessageDetails = null;
        this.detailsAvailable = false;
        boolean bl = false;
        for (StatusMessage statusMessage : this.statusMessages) {
            void var2_4;
            String details = this.getDetails(statusMessage);
            if (var2_4 == false) {
                firstMessageDetails = details;
            }
            boolean bl2 = this.detailsAvailable = !StringUtils.isEmpty(details);
            if (this.detailsAvailable) break;
            ++var2_4;
        }
        this.pnlMessage.removeAll();
        Insets insets = new Insets(2, 0, 2, 0);
        boolean bl3 = true;
        double msgCompWeighty = 1.0;
        JComponent msgComp = null;
        if (!this.multiMessageMode) {
            Dimension bestSize = SwingUtils.getBestSize(this.txaMessage, DEFAULT_UNIMODE_MESSAGE_SIZE);
            if (this.detailsAvailable) {
                bestSize.width = MessageDialog.DEFAULT_UNIMODE_MESSAGE_SIZE.width;
            }
            if (!bestSize.equals(DEFAULT_UNIMODE_MESSAGE_SIZE)) {
                msgComp = this.txaMessage;
                this.txaMessage.setPreferredSize(bestSize);
                n = 2;
                msgCompWeighty = 0.0;
                Dimension detailsSize = new Dimension(bestSize.width, MessageDialog.DEFAULT_DETAILS_SIZE.height);
                this.detailsPane.setPreferredSize(detailsSize);
            } else {
                this.unimodeMessagePane.setViewportView(this.txaMessage);
                msgComp = this.unimodeMessagePane;
            }
        } else {
            msgComp = this.multimodeMessagePane;
            Insets scrollPaneInsets = this.multimodeMessagePane.getInsets();
            Insets viewPortInsets = this.multimodeMessagePane.getViewport().getInsets();
            Dimension maxSize = new Dimension(DEFAULT_MULTIMODE_MESSAGE_SIZE);
            int widthDelta = scrollPaneInsets.right + scrollPaneInsets.left + viewPortInsets.left + viewPortInsets.right;
            int heightDelta = scrollPaneInsets.top + scrollPaneInsets.bottom + viewPortInsets.top + viewPortInsets.bottom;
            maxSize.width -= widthDelta;
            maxSize.height -= heightDelta;
            Dimension bestSize = this.lstStatusMessages.getBestSize(maxSize);
            bestSize.width += widthDelta;
            bestSize.height += heightDelta;
            this.multimodeMessagePane.setPreferredSize(bestSize);
        }
        LayoutUtils.addComponent(msgComp, this.pnlMessage, 0, 0, 1, 1, n, 17, 1.0, msgCompWeighty, insets);
        LayoutUtils.addComponent(Box.createGlue(), this.pnlMessage, 0, 1, 1, 1, 1, 17, 1.0, 1.0, LayoutUtils.EMPTY_INSETS);
        LayoutUtils.addComponent(this.txaConfirm, this.pnlMessage, 0, 2, 1, 1, 2, 17, 1.0, 0.0, new Insets(2, 0, 0, 0));
        this.populateDetails(firstMessageDetails);
        Level level = this.statusMessages.getAggregateLevel();
        this.prepareOptionPane(level, this.detailsAvailable, this.defaultOption, this.options);
        this.pnlMessage.validate();
        this.optionPane.validate();
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(this.styleFromMessageType(this.optionPane.getMessageType()));
        }
        super.pack();
    }

    protected boolean populateDetails(String details) {
        boolean updated = false;
        if (details != null && details.trim().length() > 0) {
            details = String.format(FMT_DETAILS, details);
            this.txpDetails.setText(details);
            this.txpDetails.setCaretPosition(0);
            updated = true;
            if (this.multiMessageMode) {
                this.btnDetails.setVisible(true);
                this.btnDetails.setEnabled(true);
            } else {
                this.btnDetails.setVisible(true);
            }
        } else if (this.multiMessageMode) {
            this.btnDetails.setVisible(true);
            this.btnDetails.setEnabled(false);
            this.btnDetails.setSelected(false);
        } else {
            this.btnDetails.setVisible(false);
        }
        return updated;
    }

    protected void prepareOptionPane(Level level, boolean detailsAvailable, Option defaultOption, Option ... options) {
        int messageType = 1;
        if (level == Level.SEVERE) {
            messageType = 0;
            if (options == null || options.length == 0) {
                options = OPTIONS_OK;
                defaultOption = CommonOption.OK;
            }
        } else if (level == Level.WARNING) {
            messageType = 2;
            if (options == null || options.length == 0) {
                options = OPTIONS_YES_NO;
                defaultOption = CommonOption.NO;
            }
        } else if (level == MessageLevel.QUESTION) {
            messageType = 3;
            if (options == null || options.length == 0) {
                options = OPTIONS_YES_NO;
                defaultOption = CommonOption.NO;
            }
        } else {
            messageType = 1;
            if (options == null || options.length == 0) {
                options = OPTIONS_OK;
                defaultOption = CommonOption.OK;
            }
        }
        ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>();
        for (int i = 0; i < options.length; ++i) {
            OptionButton optionButton = new OptionButton(options[i], this.optionPane, this);
            if (defaultOption == options[i]) {
                this.optionPane.setInitialSelectionValue(optionButton);
                optionButton.setDefaultCapable(true);
                this.defaultButton = optionButton;
            }
            buttons.add(optionButton);
        }
        if (detailsAvailable) {
            buttons.add(this.btnDetails);
        }
        this.optionPane.setMessageType(messageType);
        this.optionPane.setValue(defaultOption);
        this.optionPane.setOptions(buttons.toArray());
    }

    protected void reset() {
        this.lstStatusMessages.clear();
        this.options = null;
        this.defaultOption = null;
        this.statusMessages = null;
        this.detailsAvailable = false;
        this.multiMessageMode = false;
        this.btnDetails.setSelected(false);
        this.btnDetails.setEnabled(true);
        this.btnDetails.setVisible(false);
        this.detailsPane.setVisible(false);
    }

    protected String getTitle(String title) {
        title = title == null ? Application.getInstance().getName() : title;
        return title;
    }

    public Option show(String title, String message, Option defaultOption, Option ... options) {
        Option option = null;
        if (message != null) {
            option = this.show(title, new DefaultStatusMessage(Level.INFO, message), defaultOption, options);
        }
        return option == null ? defaultOption : option;
    }

    public Option show(String title, StatusMessage message, Option defaultOption, Option ... options) {
        Option option = null;
        if (message != null) {
            StatusMessages<StatusMessage> statusMessages = new StatusMessages<StatusMessage>();
            statusMessages.add(message);
            option = this.show(title, statusMessages, defaultOption, options);
            statusMessages.clear();
        }
        return option == null ? defaultOption : option;
    }

    public Option show(String title, StatusMessages<? extends StatusMessage> statusMessages, Option defaultOption, Option ... options) {
        Option option = null;
        if (statusMessages != null && !statusMessages.isEmpty()) {
            this.statusMessages = statusMessages;
            this.defaultOption = defaultOption;
            this.options = options;
            this.rebuildUI();
            title = this.getTitle(title);
            super.setTitle(title);
            super.setDefaultCloseOperation(2);
            super.setLocationRelativeTo(this.getOwner());
            super.setVisible(true);
            Object value = this.optionPane.getValue();
            if (value instanceof Option) {
                option = (Option)value;
            }
            this.reset();
        }
        return option == null ? defaultOption : option;
    }

    public Option show(String title, String message) {
        return this.show(title, message, (Option)CommonOption.OK, OPTIONS_OK);
    }

    public Option show(String title, StatusMessage message) {
        return this.show(title, message, null, new Option[0]);
    }

    public Option show(String title, StatusMessages<? extends StatusMessage> statusMessages) {
        return this.show(title, statusMessages, null, new Option[0]);
    }

    protected static class OptionButton
    extends JButton
    implements ActionListener {
        private Option option;
        private JOptionPane optionPane;
        private JDialog dialog;

        public OptionButton(Option option, JOptionPane optionPane, JDialog dialog) {
            SwingUtils.setText(this, ((Object)option).toString());
            this.option = option;
            this.optionPane = optionPane;
            this.dialog = dialog;
            this.addActionListener(this);
            this.setName(option.name());
        }

        public void actionPerformed(ActionEvent e) {
            this.optionPane.setValue(this.option);
            this.dialog.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommonOption implements Option
    {
        OK,
        CANCEL,
        YES,
        NO;


        @Override
        public String toString() {
            return resource.getString(this, new Object[0]);
        }

        @Override
        public int toInt() {
            return this.ordinal();
        }
    }

    public static class MessageLevel
    extends Level {
        public static final Level QUESTION = new MessageLevel("QUESTION", 0x70000000);

        protected MessageLevel(String name, int value) {
            super(name, value);
        }
    }
}

