/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.install.commons.swing.MultilineTableCellRenderer;
import oracle.install.commons.swing.SwingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultilineList<T>
extends JTable {
    private SingleColumnTableModel model = new SingleColumnTableModel();
    private MultilineTableCellRenderer cellRenderer;

    public MultilineList() {
        this.setCellRenderer(new MultilineTableCellRenderer());
        this.setModel(this.model);
        this.setTableHeader(null);
        this.setSelectionMode(2);
        this.setDefaultRenderer(Object.class, new MultilineTableCellRenderer());
        SwingUtils.setRowWiseFocusTraveralEnabled(this, true);
    }

    MultilineTableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    void setCellRenderer(MultilineTableCellRenderer cellRenderer) {
        this.cellRenderer = cellRenderer;
        this.setDefaultRenderer(Object.class, cellRenderer);
    }

    public Dimension getBestSize(Dimension maxSize) {
        Dimension bestSize = new Dimension();
        this.cellRenderer.setBestWidth(maxSize.width);
        bestSize.width = maxSize.width;
        int size = this.model.items.size();
        for (int i = 0; i < size; ++i) {
            Object item = this.model.items.get(i);
            this.cellRenderer.getTableCellRendererComponent(this, item, true, false, i, 0);
            bestSize.height += this.getRowHeight(i);
        }
        bestSize.width = Math.min(bestSize.width, maxSize.width);
        bestSize.height = Math.min(bestSize.height, maxSize.height);
        return bestSize;
    }

    public void setSelectedIndex(int index) {
        super.setRowSelectionInterval(index, index);
    }

    public Object getSelectedValue() {
        Object selectedValue = null;
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= 0) {
            selectedValue = this.model.getValueAt(selectedRow, 0);
        }
        return selectedValue;
    }

    public Object[] getSelectedValues() {
        ArrayList<Object> selectedValues = new ArrayList<Object>();
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows != null) {
            for (int row : selectedRows) {
                selectedValues.add(this.model.getValueAt(row, 0));
            }
        }
        return selectedValues.toArray();
    }

    public void addItem(Object item) {
        this.model.addItem(item);
    }

    public void removeItem(Object item) {
        this.model.removeItem(item);
    }

    public void clear() {
        this.model.clear();
    }

    static class SingleColumnTableModel
    extends AbstractTableModel {
        private List<Object> items = new ArrayList<Object>();

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return this.items.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.items.get(rowIndex);
        }

        public String getColumnName(int column) {
            return "";
        }

        public void addItem(Object item) {
            this.items.add(item);
        }

        public void removeItem(Object item) {
            this.items.remove(item);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public void clear() {
            this.items.clear();
        }
    }
}

