/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultilineListCellRenderer<T>
extends JPanel
implements ListCellRenderer {
    private Border defaultBorder;
    private JTextArea textArea;
    private int bestWidth;

    public MultilineListCellRenderer() {
        this.setOpaque(true);
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setOpaque(true);
        this.defaultBorder = BorderFactory.createEmptyBorder();
        this.textArea.setBorder(this.defaultBorder);
        this.setBackground(new Color(238, 238, 238));
        this.textArea.setMargin(new Insets(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.textArea, this, 0, 0, 1, 1, 1, 17, 1.0, 1.0, new Insets(0, 1, 0, 1));
    }

    public int getBestWidth() {
        return this.bestWidth;
    }

    public void setBestWidth(int bestWidth) {
        this.bestWidth = bestWidth;
    }

    public String getText(T value) {
        return value == null ? "" : value.toString();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String label = this.getText(value);
        this.textArea.setText(label);
        Insets insets = this.getInsets();
        Insets listInsets = list.getInsets();
        int messageWidth = this.getBestWidth() - (insets.right + insets.left) - (listInsets.right + listInsets.left) - 10;
        Dimension bestSize = new Dimension(messageWidth, Integer.MAX_VALUE);
        bestSize = SwingUtils.getBestSize(this.textArea, bestSize);
        this.textArea.setPreferredSize(bestSize);
        boolean enabled = list.isEnabled();
        this.textArea.setEnabled(enabled);
        this.textArea.setFont(list.getFont());
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = this.defaultBorder;
        }
        this.textArea.setBorder(border);
        if (isSelected) {
            this.textArea.setBackground(list.getSelectionBackground());
            this.textArea.setForeground(list.getSelectionForeground());
        } else {
            Color bg = list.getBackground();
            if (index % 2 == 0) {
                bg = this.getBackground();
            }
            this.textArea.setBackground(bg);
            this.textArea.setForeground(list.getForeground());
        }
        return this;
    }
}

