/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultilineTableCellRenderer<T>
extends DefaultTableCellRenderer {
    private static final String KEY_DIMENSION_TABLE = "oracle.install.commons.swing.MultilineTableCellRenderer.dimensionTable";
    private static final String KEY_ITEM_CACHE_TABLE = "oracle.install.commons.swing.MultilineTableCellRenderer.itemCacheTable";
    private static final Color COLOR_ALTERNATE = new Color(238, 238, 238);
    private static final int ROW_GAP = 10;
    private JTextArea textArea = new JTextArea();
    private int bestWidth;

    public MultilineTableCellRenderer() {
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
    }

    public int getBestWidth() {
        return this.bestWidth;
    }

    public void setBestWidth(int bestWidth) {
        this.bestWidth = bestWidth;
    }

    public String getText(T value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ItemDetails itemDetails;
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            this.textArea.setBackground(component.getBackground());
            this.textArea.setForeground(component.getForeground());
        } else {
            Color bg = component.getBackground();
            Color fg = component.getForeground();
            if (row % 2 == 0 && !fg.equals(COLOR_ALTERNATE)) {
                bg = COLOR_ALTERNATE;
            }
            this.textArea.setBackground(bg);
            this.textArea.setForeground(fg);
        }
        this.textArea.setFont(component.getFont());
        if (component instanceof JComponent) {
            JComponent c = (JComponent)component;
            this.textArea.setBorder(c.getBorder());
        }
        String text = this.getText(value);
        this.textArea.setText(text);
        WeakHashMap<Integer, ItemDetails> itemCache = (WeakHashMap<Integer, ItemDetails>)table.getClientProperty(KEY_ITEM_CACHE_TABLE);
        if (itemCache == null) {
            itemCache = new WeakHashMap<Integer, ItemDetails>();
            table.putClientProperty(KEY_ITEM_CACHE_TABLE, itemCache);
        }
        if ((itemDetails = (ItemDetails)itemCache.get(row)) == null) {
            itemDetails = new ItemDetails(text, 0);
            itemDetails = this.updateRequiredHeight(table, row, column, itemDetails);
            itemCache.put(row, itemDetails);
        } else {
            if (!(value == null || isSelected == itemDetails.isSelected() && text.equals(itemDetails.getText()))) {
                itemDetails.setText(text);
                itemDetails = this.updateRequiredHeight(table, row, column, itemDetails);
            }
            this.textArea.setSize(this.getBestWidth(), itemDetails.getHeight());
        }
        itemDetails.setSelected(isSelected);
        return this.textArea;
    }

    private ItemDetails updateRequiredHeight(JTable table, int row, int column, ItemDetails itemDetails) {
        TableColumnModel columnModel = table.getColumnModel();
        int bestWidth = this.getBestWidth();
        if (bestWidth <= 0) {
            bestWidth = columnModel.getColumn(column).getWidth();
        }
        this.textArea.setSize(bestWidth, table.getRowHeight(row));
        int heightRequired = this.textArea.getPreferredSize().height + 10;
        this.updateRequiredCellHeight(table, row, column, heightRequired);
        heightRequired = this.findMaximumRowHeight(table, row, column);
        if (heightRequired != table.getRowHeight(row)) {
            table.setRowHeight(row, heightRequired);
        }
        itemDetails.setHeight(heightRequired);
        return itemDetails;
    }

    private void updateRequiredCellHeight(JTable table, int row, int column, int height) {
        HashMap<Integer, Integer> rowheights;
        HashMap<Integer, HashMap<Integer, Integer>> dimensionTable = (HashMap<Integer, HashMap<Integer, Integer>>)table.getClientProperty(KEY_DIMENSION_TABLE);
        if (dimensionTable == null) {
            dimensionTable = new HashMap<Integer, HashMap<Integer, Integer>>();
            table.putClientProperty(KEY_DIMENSION_TABLE, dimensionTable);
        }
        if ((rowheights = (HashMap<Integer, Integer>)dimensionTable.get(row)) == null) {
            rowheights = new HashMap<Integer, Integer>();
            dimensionTable.put(row, rowheights);
        }
        rowheights.put(column, height);
    }

    private int findMaximumRowHeight(JTable table, int row, int column) {
        int maximum_height = 0;
        Map dimensionTable = (Map)table.getClientProperty(KEY_DIMENSION_TABLE);
        if (dimensionTable != null) {
            Map rowheights = (Map)dimensionTable.get(new Integer(row));
            if (rowheights == null) {
                return 0;
            }
            for (Map.Entry e : rowheights.entrySet()) {
                int cellHeight = (Integer)e.getValue();
                maximum_height = Math.max(maximum_height, cellHeight);
            }
        }
        return maximum_height;
    }

    class ItemDetails {
        private String text;
        private int height;
        private boolean selected;

        public ItemDetails(String text, int height) {
            this.text = text;
            this.height = height;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

