/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.install.commons.swing.ErrorDialog;
import oracle.install.commons.swing.MessageDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.DefaultStatusMessage;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardDialog {
    public static boolean promptInput(Component owner, String title, Component content) {
        InputDialogShowTask callable = new InputDialogShowTask(owner, title, content);
        return SwingUtils.invokeTask(callable);
    }

    public static boolean promptConfirmation(Component owner, String message) {
        return StandardDialog.promptConfirmation(owner, null, message, false);
    }

    public static boolean promptConfirmation(Component owner, String title, String message, boolean defaultAnswer) {
        Option option = StandardDialog.showMessage(owner, title, message, Level.WARNING, (Option)(defaultAnswer ? MessageDialog.CommonOption.OK : MessageDialog.CommonOption.CANCEL), MessageDialog.OPTIONS_OK_CANCEL);
        return option == MessageDialog.CommonOption.OK;
    }

    public static boolean promptQuestion(Component owner, String message) {
        return StandardDialog.promptQuestion(owner, null, message, false);
    }

    public static boolean promptQuestion(Component owner, String title, String message, boolean defaultAnswer) {
        Option option = StandardDialog.showMessage(owner, title, message, MessageDialog.MessageLevel.QUESTION, (Option)(defaultAnswer ? MessageDialog.CommonOption.YES : MessageDialog.CommonOption.NO), MessageDialog.OPTIONS_YES_NO);
        return option == MessageDialog.CommonOption.YES;
    }

    public static void showInformation(Component owner, String message) {
        StandardDialog.showInformation(owner, null, message);
    }

    public static void showInformation(Component owner, String title, String message) {
        MessageDialogShowTask callable = new MessageDialogShowTask(owner, title, message, Level.INFO);
        SwingUtils.invokeTask(callable);
    }

    public static void showError(Component owner, String message) {
        StandardDialog.showError(owner, null, message);
    }

    public static Advice showError(Component owner, ErrorCode errorCode, Object ... messageArgs) {
        return StandardDialog.showError(owner, null, errorCode, messageArgs);
    }

    public static Advice showError(Component owner, Throwable e) {
        return StandardDialog.showError(owner, null, e);
    }

    public static Advice showError(Component owner, ErrorMessage errorMessage) {
        return StandardDialog.showError(owner, null, errorMessage);
    }

    public static Advice showErrors(Component owner, StatusMessages<? extends ErrorMessage> errorMessages) {
        return StandardDialog.showErrors(owner, null, errorMessages);
    }

    public static void showError(Component owner, String title, String message) {
        MessageDialogShowTask callable = new MessageDialogShowTask(owner, title, message, Level.SEVERE);
        SwingUtils.invokeTask(callable);
    }

    public static Advice showError(Component owner, String title, ErrorCode errorCode, Object ... messageArgs) {
        DefaultErrorMessage errorMessage = new DefaultErrorMessage(errorCode, messageArgs);
        return StandardDialog.showError(owner, title, errorMessage);
    }

    public static Advice showError(Component owner, String title, Throwable e) {
        DefaultErrorMessage errorMessage = new DefaultErrorMessage(e);
        return StandardDialog.showError(owner, title, errorMessage);
    }

    public static Advice showError(Component owner, String title, ErrorMessage errorMessage) {
        ErrorDialogShowTask callable = new ErrorDialogShowTask(owner, title, errorMessage);
        return SwingUtils.invokeTask(callable);
    }

    public static Advice showErrors(Component owner, String title, StatusMessages<? extends ErrorMessage> errorMessages) {
        ErrorDialogShowTask callable = new ErrorDialogShowTask(owner, title, errorMessages);
        return SwingUtils.invokeTask(callable);
    }

    public static void showWarning(Component owner, String message) {
        StandardDialog.showWarning(owner, null, message);
    }

    public static void showWarning(Component owner, String title, String message) {
        StandardDialog.showMessage(owner, title, message, Level.WARNING, (Option)MessageDialog.CommonOption.OK, MessageDialog.OPTIONS_OK);
    }

    public static Option showMessage(Component owner, String title, String message, Level level, Option defaultOption, Option ... options) {
        return StandardDialog.showMessage(owner, title, new DefaultStatusMessage(level, message), defaultOption, options);
    }

    public static Option showMessage(Component owner, String title, String message, Level level) {
        return StandardDialog.showMessage(owner, title, message, level, null, new Option[0]);
    }

    public static Option showMessage(Component owner, String title, DefaultStatusMessage message, Option defaultOption, Option ... options) {
        MessageDialogShowTask callable = new MessageDialogShowTask(owner, title, message, defaultOption, options);
        return SwingUtils.invokeTask(callable);
    }

    public static Option showMessages(Component owner, String title, StatusMessages<? extends DefaultStatusMessage> messages, Option defaultOption, Option ... options) {
        MessageDialogShowTask callable = new MessageDialogShowTask(owner, title, messages, defaultOption, options);
        return SwingUtils.invokeTask(callable);
    }

    public static Option showMessages(Component owner, String title, StatusMessages<? extends DefaultStatusMessage> messages) {
        MessageDialogShowTask callable = new MessageDialogShowTask(owner, title, messages, null, new Option[0]);
        return SwingUtils.invokeTask(callable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MessageDialogShowTask
    implements Callable<Option> {
        private Component owner;
        private String title;
        private StatusMessages<? extends DefaultStatusMessage> messages;
        private Option defaultOption;
        private Option[] options;

        public MessageDialogShowTask(Component owner, String title, String message, Level level) {
            this(owner, title, new DefaultStatusMessage(level, message), (Option)MessageDialog.CommonOption.OK, MessageDialog.OPTIONS_OK);
        }

        public MessageDialogShowTask(Component owner, String title, DefaultStatusMessage message, Option defaultOption, Option ... options) {
            this.owner = owner;
            this.title = title;
            StatusMessages<DefaultStatusMessage> statusMessages = new StatusMessages<DefaultStatusMessage>();
            statusMessages.add(message);
            this.messages = statusMessages;
            this.defaultOption = defaultOption;
            this.options = options;
        }

        public MessageDialogShowTask(Component owner, String title, StatusMessages<? extends DefaultStatusMessage> messages, Option defaultOption, Option ... options) {
            this.owner = owner;
            this.title = title;
            this.messages = messages;
            this.defaultOption = defaultOption;
            this.options = options;
        }

        @Override
        public Option call() throws Exception {
            if (this.title == null) {
                this.title = Application.getInstance().getName();
            }
            MessageDialog messageDialog = SwingUtils.createDialog(this.owner, MessageDialog.class);
            Option option = messageDialog.show(this.title, this.messages, this.defaultOption, this.options);
            messageDialog = null;
            return option;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorDialogShowTask
    implements Callable<Advice> {
        private Component owner;
        private String title;
        private StatusMessages<? extends ErrorMessage> errorMessages;

        public ErrorDialogShowTask(Component owner, String title, StatusMessages<? extends ErrorMessage> errorMessages) {
            this.owner = owner;
            this.title = title;
            this.errorMessages = errorMessages;
        }

        public ErrorDialogShowTask(Component owner, String title, ErrorMessage errorMessage) {
            this.owner = owner;
            this.title = title;
            StatusMessages<ErrorMessage> statusMessages = new StatusMessages<ErrorMessage>();
            statusMessages.add(errorMessage);
            this.errorMessages = statusMessages;
        }

        @Override
        public Advice call() throws Exception {
            ErrorDialog errorDialog = SwingUtils.createDialog(this.owner, ErrorDialog.class);
            Advice advice = errorDialog.advise(this.title, this.errorMessages);
            errorDialog.dispose();
            errorDialog = null;
            return advice;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputDialogShowTask
    implements Callable<Boolean> {
        private Component owner;
        private String title;
        private Component content;

        public InputDialogShowTask(Component owner, String title, Component content) {
            this.owner = owner;
            this.title = title;
            this.content = content;
        }

        @Override
        public Boolean call() throws Exception {
            JOptionPane optionPane = new JOptionPane();
            optionPane.setMessage(this.content);
            JDialog dialog = optionPane.createDialog(SwingUtils.getRoot(this.owner), this.title);
            Object[] options = new MessageDialog.OptionButton[]{new MessageDialog.OptionButton(MessageDialog.CommonOption.OK, optionPane, dialog), new MessageDialog.OptionButton(MessageDialog.CommonOption.CANCEL, optionPane, dialog)};
            optionPane.setOptions(options);
            optionPane.setInitialValue(options[0]);
            dialog.setVisible(true);
            Object value = optionPane.getValue();
            dialog = null;
            optionPane = null;
            return value == MessageDialog.CommonOption.OK;
        }
    }
}

