/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing.treetable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.install.commons.swing.tree.TreeUtils;
import oracle.install.commons.swing.treetable.AbstractTreeTableModel;
import oracle.install.commons.swing.treetable.NodeAccessor;
import oracle.install.commons.swing.treetable.NodeAccessorAdaptor;
import oracle.install.commons.swing.treetable.TreeTableColumn;
import oracle.install.commons.swing.treetable.TreeTableModel;
import oracle.install.commons.swing.treetable.TreeTableModelEvent;
import oracle.install.commons.swing.treetable.TreeTableModelListener;

public class DefaultTreeTableModel
extends AbstractTreeTableModel
implements PropertyChangeListener {
    protected TreeTableColumn[] columns;
    protected NodeAccessor nodeAccessor;
    protected PropertyChangeSupport propertyChangeSupport;
    private boolean descriptionColumnHideable;
    private boolean ordered;
    private int orderingScheme;
    private Comparator nodeComparator;
    private ArrayList listenerList = new ArrayList();

    public DefaultTreeTableModel() {
        this(new DefaultMutableTreeNode(), new TreeTableColumn[]{new TreeTableColumn("Default Column", TreeTableModel.class)}, new NodeAccessorAdaptor());
    }

    public DefaultTreeTableModel(DefaultMutableTreeNode root) {
        this(root, new TreeTableColumn[]{new TreeTableColumn("Default Column", TreeTableModel.class)}, new NodeAccessorAdaptor());
    }

    public DefaultTreeTableModel(DefaultMutableTreeNode root, TreeTableColumn[] columns) {
        this(root, columns, new NodeAccessorAdaptor());
    }

    public DefaultTreeTableModel(DefaultMutableTreeNode root, TreeTableColumn[] columns, NodeAccessor nodeAccessor) {
        super(root);
        this.nodeAccessor = nodeAccessor;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.setColumns(columns);
        this.descriptionColumnHideable = true;
        this.ordered = true;
        this.orderingScheme = TreeUtils.ASCENDING_ORDER;
    }

    public Comparator getNodeComparator() {
        return this.nodeComparator;
    }

    public void setNodeComparator(Comparator nodeComparator) {
        this.nodeComparator = nodeComparator;
    }

    public boolean isDescriptionColumnHideable() {
        return this.descriptionColumnHideable;
    }

    public void setDescriptionColumnHideable(boolean descriptionColumnHideable) {
        this.descriptionColumnHideable = descriptionColumnHideable;
    }

    public TreeTableColumn getColumnAt(int index) {
        return this.columns[index];
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public int getOrderingScheme() {
        return this.orderingScheme;
    }

    public void setOrderingScheme(int orderingScheme) {
        this.orderingScheme = orderingScheme;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("TreeTableColumn.visibility")) {
            this.propertyChangeSupport.firePropertyChange("DefaultTreeTableModel.columnsVisibility", null, this.columns);
        }
    }

    public void addTreeTableModelListener(TreeTableModelListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeTreeTableModelListener(TreeTableModelListener listener) {
        this.listenerList.remove(listener);
    }

    public void fireTreeTableModelEvent(int id, DefaultMutableTreeNode node) {
        this.fireTreeTableModelEvent(new TreeTableModelEvent(id, this, node));
    }

    public void fireTreeTableModelEvent(TreeTableModelEvent e) {
        for (TreeTableModelListener listener : this.listenerList) {
            listener.stateChanged(e);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public NodeAccessor getNodeAccessor() {
        return this.nodeAccessor;
    }

    public void setNodeAccessor(NodeAccessor nodeAccessor) {
        this.nodeAccessor = nodeAccessor;
    }

    public TreeTableColumn[] getColumns() {
        return this.columns;
    }

    public void setColumns(TreeTableColumn[] columns) {
        int i;
        TreeTableColumn[] oldColumns = this.columns;
        if (oldColumns != null) {
            for (i = 0; i < oldColumns.length; ++i) {
                oldColumns[i].removePropertyChangeListener(this);
            }
        }
        this.columns = columns;
        for (i = 0; i < this.columns.length; ++i) {
            this.columns[i].addPropertyChangeListener(this);
        }
        this.propertyChangeSupport.firePropertyChange("DefaultTreeTableModel.columns", oldColumns, columns);
    }

    public Object getValueAt(Object node, int column) {
        return this.nodeAccessor.getValueAt(node, column);
    }

    public int getChildCount(Object node) {
        if (node != null) {
            Object[] children = this.getChildren(node);
            return children == null ? 0 : children.length;
        }
        return 0;
    }

    public Object getChild(Object node, int i) {
        if (node != null) {
            return this.getChildren(node)[i];
        }
        return null;
    }

    public int getColumnCount() {
        int count = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            count += this.columns[i].isVisible() ? 1 : 0;
        }
        return count;
    }

    public int translateColumnIndex(int columnIndex) {
        if (!this.descriptionColumnHideable) {
            return columnIndex;
        }
        int newIndex = -1;
        int count = -1;
        for (int i = 0; i < this.columns.length; ++i) {
            if ((count += this.columns[i].isVisible() ? 1 : 0) != columnIndex) continue;
            return i;
        }
        return newIndex;
    }

    public String getColumnName(int column) {
        return this.columns[this.translateColumnIndex(column)].getName();
    }

    public Class getColumnClass(int column) {
        return this.columns[this.translateColumnIndex(column)].getType();
    }

    protected Object[] getChildren(Object node) {
        if (node != null && node instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defNode = (DefaultMutableTreeNode)node;
            Object[] children = new Object[defNode.getChildCount()];
            int i = 0;
            Enumeration<TreeNode> e = defNode.children();
            while (e.hasMoreElements()) {
                children[i++] = e.nextElement();
            }
            return children;
        }
        return null;
    }

    public boolean isLeaf(Object node) {
        if (node != null) {
            DefaultMutableTreeNode defNode = (DefaultMutableTreeNode)node;
            return defNode.isLeaf();
        }
        return false;
    }

    public boolean isDuplicate(DefaultMutableTreeNode searchNode, Comparator comparator) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> orgNodesList = root.breadthFirstEnumeration();
        while (orgNodesList.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)orgNodesList.nextElement();
            if (comparator.compare(node, searchNode) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isDuplicate(DefaultMutableTreeNode searchNode) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> orgNodesList = root.breadthFirstEnumeration();
        while (orgNodesList.hasMoreElements()) {
            DefaultMutableTreeNode orgNode = (DefaultMutableTreeNode)orgNodesList.nextElement();
            if (!orgNode.equals(searchNode)) continue;
            return true;
        }
        return false;
    }

    public void addNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode node) throws Exception {
        if (this.ordered) {
            TreeUtils.addNodeInOrder(parent, node, this.orderingScheme, this.nodeComparator);
        } else {
            parent.add(node);
        }
        int[] childIndices = new int[]{parent.getIndex(node)};
        Object[] path = parent.getPath();
        Object[] children = new Object[]{node};
        this.fireTreeNodesInserted(this, path, childIndices, children);
        this.fireTreeTableModelEvent(1, node);
    }

    public boolean removeNode(DefaultMutableTreeNode node) throws Exception {
        if (node.isRoot()) {
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        int[] childIndices = new int[]{parent.getIndex(node)};
        Object[] path = parent.getPath();
        Object[] children = new Object[]{node};
        node.removeFromParent();
        this.fireTreeNodesRemoved(this, path, childIndices, children);
        this.fireTreeTableModelEvent(2, node);
        return true;
    }

    public boolean isMovable(DefaultMutableTreeNode newParent, DefaultMutableTreeNode node) {
        return !node.isNodeDescendant(newParent);
    }

    public boolean moveNode(DefaultMutableTreeNode newParent, DefaultMutableTreeNode node) throws Exception {
        if (!this.isMovable(newParent, node)) {
            return false;
        }
        DefaultMutableTreeNode oldParent = (DefaultMutableTreeNode)node.getParent();
        int[] childIndices = new int[]{oldParent.getIndex(node)};
        Object[] path = oldParent.getPath();
        Object[] children = new Object[]{node};
        node.removeFromParent();
        this.fireTreeNodesRemoved(this, path, childIndices, children);
        newParent.add(node);
        childIndices = new int[]{newParent.getIndex(node)};
        path = newParent.getPath();
        children = new Object[]{node};
        this.fireTreeNodesInserted(this, path, childIndices, children);
        this.fireTreeTableModelEvent(4, node);
        return true;
    }

    public void refreshNode(DefaultMutableTreeNode node) {
        Object[] path;
        int[] childIndices;
        Object[] children = new Object[]{node};
        if (!node.isRoot()) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            childIndices = new int[]{parent.getIndex(node)};
            path = parent.getPath();
        } else {
            path = node.getPath();
            childIndices = new int[]{};
        }
        this.fireTreeNodesChanged(this, path, childIndices, children);
        this.fireTreeTableModelEvent(3, node);
    }

    public void reload() {
        this.reload((DefaultMutableTreeNode)this.getRoot());
    }

    public void reload(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> nodeList = root.preorderEnumeration();
        while (nodeList.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeList.nextElement();
            if (node.isLeaf() || node.getChildCount() <= 0) continue;
            int[] childIndices = new int[node.getChildCount()];
            Object[] children = new Object[node.getChildCount()];
            for (int i = 0; i < childIndices.length; ++i) {
                children[i] = node.getChildAt(i);
                childIndices[i] = i;
            }
            Object[] path = node.getPath();
            this.fireTreeNodesChanged(this, path, childIndices, children);
        }
        this.fireTreeTableModelEvent(3, root);
    }

    public void reset() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> nodeList = root.postorderEnumeration();
        while (nodeList.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeList.nextElement();
            if (node.isLeaf() || node.getChildCount() <= 0) continue;
            int[] childIndices = new int[node.getChildCount()];
            Object[] children = new Object[node.getChildCount()];
            for (int i = 0; i < childIndices.length; ++i) {
                children[i] = node.getChildAt(i);
                childIndices[i] = i;
            }
            Object[] path = node.getPath();
            node.removeAllChildren();
            this.fireTreeNodesRemoved(this, path, childIndices, children);
        }
        this.fireTreeTableModelEvent(3, root);
    }

    public int getTreeColumn() {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getType().equals(TreeTableModel.class)) continue;
            return i;
        }
        return -1;
    }
}

