/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing.treetable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.install.commons.swing.treetable.JTreeTableEx;

class JTreeTablePane
extends JComponent
implements Serializable {
    private JTreeTableEx treeTable;
    private JToolBar toolBar;

    public JTreeTablePane() {
        this.buildUI();
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        JButton btnMoveUp = new JButton(UIManager.getIcon("TreeTablePane.moveUp"));
        btnMoveUp.setActionCommand("1");
        btnMoveUp.setToolTipText("Move up");
        btnMoveUp.setRolloverEnabled(true);
        btnMoveUp.setRolloverIcon(UIManager.getIcon("TreeTablePane.rollover.moveUp"));
        JButton btnMoveDown = new JButton(UIManager.getIcon("TreeTablePane.moveDown"));
        btnMoveDown.setActionCommand("2");
        btnMoveDown.setRolloverIcon(UIManager.getIcon("TreeTablePane.rollover.moveDown"));
        btnMoveDown.setToolTipText("Move down");
        JButton btnShiftUp = new JButton(UIManager.getIcon("TreeTablePane.shiftUp"));
        btnShiftUp.setActionCommand("3");
        btnShiftUp.setRolloverIcon(UIManager.getIcon("TreeTablePane.rollover.shiftUp"));
        btnShiftUp.setToolTipText("Shift up the hierarchy");
        JButton btnShiftDown = new JButton(UIManager.getIcon("TreeTablePane.shiftDown"));
        btnShiftDown.setActionCommand("4");
        btnShiftDown.setRolloverIcon(UIManager.getIcon("TreeTablePane.rollover.shiftDown"));
        btnShiftDown.setToolTipText("Shift down the hierarchy");
        JButton btnExpandAll = new JButton(UIManager.getIcon("TreeTablePane.expandAll"));
        btnExpandAll.setActionCommand("5");
        btnExpandAll.setRolloverIcon(UIManager.getIcon("TreeTablePane.rollover.expandAll"));
        btnExpandAll.setToolTipText("Expand All");
        JButton btnCollapseAll = new JButton(UIManager.getIcon("TreeTablePane.collapseAll"));
        btnCollapseAll.setActionCommand("6");
        btnCollapseAll.setRolloverIcon(UIManager.getIcon("TreeTablePane.rollover.collapseAll"));
        btnCollapseAll.setToolTipText("Collapse All");
        JButton btnExpandNode = new JButton(UIManager.getIcon("TreeTablePane.expandNode"));
        btnExpandNode.setActionCommand("7");
        btnExpandNode.setRolloverIcon(UIManager.getIcon("TreeTablePane.rollover.expandNode"));
        btnExpandNode.setToolTipText("Expand Selected Nodes");
        JButton btnCollapseNode = new JButton(UIManager.getIcon("TreeTablePane.collapseNode"));
        btnCollapseNode.setActionCommand("8");
        btnCollapseNode.setRolloverIcon(UIManager.getIcon("TreeTablePane.rollover.collapseNode"));
        btnCollapseNode.setToolTipText("Collapse Selected Nodes");
        JButton btnExpandSubtree = new JButton(UIManager.getIcon("TreeTablePane.expandSubtree"));
        btnExpandSubtree.setActionCommand("9");
        btnExpandSubtree.setRolloverIcon(UIManager.getIcon("TreeTablePane.rollover.expandSubtree"));
        btnExpandSubtree.setToolTipText("Expand Subtree");
        this.toolBar.add(btnShiftUp);
        this.toolBar.add(btnShiftDown);
        this.toolBar.add(btnMoveUp);
        this.toolBar.add(btnMoveDown);
        this.toolBar.add(btnExpandAll);
        this.toolBar.add(btnCollapseAll);
        this.toolBar.add(btnExpandNode);
        this.toolBar.add(btnCollapseNode);
        this.toolBar.add(btnExpandSubtree);
        this.treeTable = new JTreeTableEx();
        this.add((Component)this.toolBar, "North");
        this.add(new JScrollPane(this.treeTable));
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JButton source = (JButton)e.getSource();
                int index = Integer.parseInt(source.getActionCommand());
                DefaultMutableTreeNode node = JTreeTablePane.this.treeTable.getSelectedNode();
                if (node != null || index == 5 || index == 6) {
                    switch (index) {
                        case 1: {
                            break;
                        }
                        case 3: {
                            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                            if (node.isRoot() || parent.isRoot()) break;
                            try {
                                JTreeTablePane.this.treeTable.moveNode((DefaultMutableTreeNode)parent.getParent(), node);
                            }
                            catch (Exception ex) {
                                Toolkit.getDefaultToolkit().beep();
                            }
                            return;
                        }
                        case 4: {
                            DefaultMutableTreeNode sibling = node.getPreviousSibling();
                            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                            if (sibling == null) break;
                            try {
                                JTreeTablePane.this.treeTable.moveNode(sibling, node);
                            }
                            catch (Exception ex) {
                                Toolkit.getDefaultToolkit().beep();
                            }
                            return;
                        }
                        case 5: {
                            JTreeTablePane.this.treeTable.expandAll();
                            break;
                        }
                        case 6: {
                            JTreeTablePane.this.treeTable.collapseAll();
                            break;
                        }
                        case 7: {
                            JTreeTablePane.this.treeTable.setNodeExpanded(node, true);
                            break;
                        }
                        case 8: {
                            JTreeTablePane.this.treeTable.setNodeExpanded(node, false);
                            break;
                        }
                        case 9: {
                            JTreeTablePane.this.treeTable.setSubTreeExpanded(node, true);
                        }
                    }
                    if (node != null) {
                        JTreeTablePane.this.treeTable.setSelectedNode(node);
                    }
                }
                Toolkit.getDefaultToolkit().beep();
            }
        };
        btnShiftUp.addActionListener(listener);
        btnShiftDown.addActionListener(listener);
        btnMoveUp.addActionListener(listener);
        btnMoveDown.addActionListener(listener);
        btnExpandAll.addActionListener(listener);
        btnCollapseAll.addActionListener(listener);
        btnExpandNode.addActionListener(listener);
        btnCollapseNode.addActionListener(listener);
        btnExpandSubtree.addActionListener(listener);
    }

    public JTreeTableEx getTreeTable() {
        return this.treeTable;
    }

    public void setTreeTable(JTreeTableEx treetable) {
        this.treeTable = treetable;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(JToolBar toolbar) {
        this.toolBar = toolbar;
    }
}

