/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing.treetable;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import oracle.install.commons.swing.treetable.DefaultTreeTableModel;
import oracle.install.commons.swing.treetable.JTreeTableEx;
import oracle.install.commons.swing.treetable.TreeTableColumn;
import oracle.install.commons.swing.treetable.TreeTableModel;

class TreeTableHeaderPopup
extends JPopupMenu
implements PropertyChangeListener {
    private DefaultTreeTableModel model;

    public TreeTableHeaderPopup(JTreeTableEx treeTable) {
        this.model = treeTable.getTreeTableModel();
        treeTable.addPropertyChangeListener(this);
        this.model.addPropertyChangeListener(this);
        this.buildMenu();
    }

    private void buildMenu() {
        this.removeAll();
        TreeTableColumn[] columns = this.model.getColumns();
        if (columns.length > 0) {
            JPanel pnlTitle = new JPanel();
            pnlTitle.add(new JLabel("Show"));
            this.add(pnlTitle);
            this.add(new JSeparator());
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].getType().equals(TreeTableModel.class)) continue;
                this.add(new ColumnMenuItem(columns[i]));
            }
        }
        this.validate();
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("JTreeTableEx.model")) {
            this.model.removePropertyChangeListener(this);
            this.model = (DefaultTreeTableModel)e.getNewValue();
            this.model.addPropertyChangeListener(this);
            this.buildMenu();
        } else if (propertyName.equals("DefaultTreeTableModel.columns")) {
            this.buildMenu();
        } else if (propertyName.equals("DefaultTreeTableModel.columnsVisibility")) {
            // empty if block
        }
    }

    class ColumnMenuItem
    extends JCheckBoxMenuItem
    implements ActionListener,
    PropertyChangeListener {
        private TreeTableColumn column;

        public ColumnMenuItem(TreeTableColumn column) {
            super(column.getName(), column.isVisible());
            this.column = column;
            this.column.addPropertyChangeListener(this);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            this.column.setVisible(this.isSelected());
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("TreeTableColumn.visibility")) {
                this.setSelected(this.column.isVisible());
            }
        }
    }
}

