/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing.validate;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.Validator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.validate.ValidationComponentFactory;
import oracle.install.commons.util.exception.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineValidationHelper {
    public static final Object[] SUPPORTED_VALIDATION_TYPES = new Object[]{ValidationComponent.FOCUS_CHANGE_VALIDATOR, ValidationComponent.MODEL_CHANGE_VALIDATOR};
    private static Map<Component, Set<ValidationComponent>> inlineValidatorMap = new HashMap<Component, Set<ValidationComponent>>();

    public static ValidationMessage translateValidationStatusMessage(ValidationStatusMessage validationStatusMessage) {
        ValidationMessage validationMessage = null;
        if (validationStatusMessage != null) {
            Severity severity = validationStatusMessage.getSeverity();
            validationMessage = new ValidationMessage(severity == Severity.FATAL ? 1 : 2, validationStatusMessage.getMessage());
        }
        return validationMessage;
    }

    public static ValidationMessage translateValidationException(ValidationException validationException) {
        ValidationMessage validationMessage = null;
        if (validationException != null) {
            Severity severity = validationException.getSeverity();
            validationMessage = new ValidationMessage(severity == Severity.FATAL ? 1 : 2, validationException.getLocalizedMessage());
        }
        return validationMessage;
    }

    public static void registerInlineValidator(Component view, ValidationComponent inlineValidator) {
        if (view != null && inlineValidator != null) {
            Set<ValidationComponent> validatorSet = inlineValidatorMap.get(view);
            if (validatorSet == null) {
                validatorSet = new HashSet<ValidationComponent>();
                inlineValidatorMap.put(view, validatorSet);
            }
            if (!validatorSet.contains(inlineValidator)) {
                Component component = inlineValidator.getComponent();
                ComponentListeners compLsnr = new ComponentListeners(inlineValidator);
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).getDocument().addDocumentListener(compLsnr);
                }
                component.addPropertyChangeListener(compLsnr);
                for (Object validationType : SUPPORTED_VALIDATION_TYPES) {
                    Validator[] validators = inlineValidator.getValidators(validationType);
                    if (validators == null) continue;
                    for (Validator validator : validators) {
                        if (validator instanceof ValidatorProxy) continue;
                        inlineValidator.removeValidator(validationType, validator);
                        inlineValidator.addValidator(validationType, (Validator)new ValidatorProxy(validator));
                    }
                }
                validatorSet.add(inlineValidator);
            }
        }
    }

    public static void registerInlineValidator(Component view, Component component, Validator inlineValidator, Object validationType) {
        ValidationComponent validationComponent;
        if (inlineValidator != null && validationType != null && (validationComponent = ValidationComponentFactory.getValidationComponent(component)) != null) {
            validationComponent.addValidator(validationType, inlineValidator);
            InlineValidationHelper.registerInlineValidator(view, validationComponent);
        }
    }

    public static Set<ValidationComponent> getRegisteredInlineValidators(Component view) {
        return inlineValidatorMap.get(view);
    }

    static class ComponentListeners
    implements PropertyChangeListener,
    DocumentListener {
        private boolean textEdited;
        private ValidationComponent inlineValidator;

        public ComponentListeners(ValidationComponent validator) {
            this.inlineValidator = validator;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            boolean inlineValidate = false;
            boolean invokeFocusChangeValidator = true;
            if ("text".equals(evt.getPropertyName())) {
                this.textEdited = true;
                inlineValidate = true;
            }
            if ("enabled".equals(evt.getPropertyName()) && this.textEdited) {
                inlineValidate = true;
                Component component = (Component)evt.getSource();
                boolean bl = invokeFocusChangeValidator = evt.getNewValue() != Boolean.TRUE || component.isFocusOwner();
            }
            if ("visible".equals(evt.getPropertyName()) && this.textEdited) {
                inlineValidate = true;
            }
            if (inlineValidate) {
                this.inlineValidator.validateComponent(ValidationComponent.DEFAULT_VALIDATOR);
                this.inlineValidator.validateComponent(ValidationComponent.MODEL_CHANGE_VALIDATOR);
                if (invokeFocusChangeValidator) {
                    this.inlineValidator.validateComponent(ValidationComponent.FOCUS_CHANGE_VALIDATOR);
                }
            }
        }

        public void changedUpdate(DocumentEvent e) {
            this.textEdited = true;
        }

        public void insertUpdate(DocumentEvent e) {
            this.textEdited = true;
        }

        public void removeUpdate(DocumentEvent e) {
            this.textEdited = true;
        }
    }

    static class ValidatorProxy
    implements Validator {
        private Validator delegate;

        public ValidatorProxy(Validator delegate) {
            this.delegate = delegate;
        }

        public ValidationMessage[] validate(Component component, Object data) {
            ValidationMessage[] result = null;
            if (data != null && component.isEnabled()) {
                result = this.delegate.validate(component, data);
            }
            return result;
        }
    }
}

