/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing.validate;

import java.awt.Component;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.validate.JTextValidationComponent;
import oracle.bali.ewt.validate.JTextValidationHandler;
import oracle.bali.ewt.validate.ValidationComponent;

public class ValidationComponentFactory {
    private static final JTextValidationHandler textValidationHandler = new JTextValidationHandler();

    public static ValidationComponent getValidationComponent(Component component) {
        ValidationComponent validationComponent = null;
        if (component instanceof JTextComponent) {
            validationComponent = ValidationComponentFactory.getValidationComponent((JTextComponent)component);
        } else if (component instanceof JComboBox) {
            validationComponent = ValidationComponentFactory.getValidationComponent((JComboBox)component);
        }
        return validationComponent;
    }

    public static ValidationComponent getValidationComponent(JTextComponent component) {
        JTextValidationComponent validationComponent = new JTextValidationComponent(component);
        textValidationHandler.registerComponent((ValidationComponent)validationComponent);
        return validationComponent;
    }

    public static ValidationComponent getValidationComponent(JComboBox comboBox) {
        ComboBoxEditor editor;
        ValidationComponent validationComponent = null;
        if (comboBox.isEditable() && (editor = comboBox.getEditor()) != null) {
            Component editorComponent = editor.getEditorComponent();
            validationComponent = ValidationComponentFactory.getValidationComponent(editorComponent);
        }
        return validationComponent;
    }
}

