/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.system.process;

import java.util.List;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessEvent;
import oracle.install.commons.system.process.ProcessListener;
import oracle.install.commons.system.process.ProcessMonitor;
import oracle.install.commons.util.EventSupport;

public class ProcessLaunchInfo {
    private long timeout;
    private EventSupport<ProcessEvent> eventSupport = new EventSupport();
    private OutputProcessor stdoutProcessor;
    private OutputProcessor stderrProcessor;
    private ProcessBuilder processBuilder;

    public ProcessLaunchInfo(String executable, String ... args) {
        this(executable, (OutputProcessor)null, (OutputProcessor)null, args);
    }

    public ProcessLaunchInfo(String executable, long timeout, String ... args) {
        this(executable, null, null, timeout, args);
    }

    public ProcessLaunchInfo(String executable, OutputProcessor stdoutProcessor, OutputProcessor stderrProcessor, String ... args) {
        this(ProcessLaunchInfo.createProcessBuilder(executable, args), stdoutProcessor, stderrProcessor);
    }

    public ProcessLaunchInfo(String executable, OutputProcessor stdoutProcessor, OutputProcessor stderrProcessor, long timeout, String ... args) {
        this(ProcessLaunchInfo.createProcessBuilder(executable, args), stdoutProcessor, stderrProcessor, timeout);
    }

    public ProcessLaunchInfo(ProcessBuilder processBuilder) {
        this(processBuilder, null, null, -1L);
    }

    public ProcessLaunchInfo(ProcessBuilder processBuilder, OutputProcessor stdoutProcessor, OutputProcessor stderrProcessor) {
        this(processBuilder, stdoutProcessor, stderrProcessor, -1L);
    }

    public ProcessLaunchInfo(ProcessBuilder processBuilder, OutputProcessor stdoutProcessor, OutputProcessor stderrProcessor, long timeout) {
        this.stdoutProcessor = stdoutProcessor;
        this.stderrProcessor = stderrProcessor;
        this.processBuilder = processBuilder;
        this.timeout = timeout;
        if (timeout > 0L) {
            this.eventSupport.addEventListener(new ProcessMonitor(timeout));
        }
    }

    public String getExecutable() throws NullPointerException, IllegalArgumentException {
        String executable = null;
        if (this.processBuilder == null) {
            throw new NullPointerException();
        }
        List<String> command = this.processBuilder.command();
        if (command == null || command.isEmpty()) {
            throw new IllegalArgumentException();
        }
        executable = command.get(0);
        if (executable == null || executable.length() == 0) {
            throw new IllegalArgumentException();
        }
        return executable;
    }

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }

    public OutputProcessor getStderrProcessor() {
        return this.stderrProcessor;
    }

    public OutputProcessor getStdoutProcessor() {
        return this.stdoutProcessor;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void addProcessListener(ProcessListener processListener) {
        this.eventSupport.addEventListener(processListener);
    }

    public void removeProcessListener(ProcessListener processListener) {
        this.eventSupport.removeEventListener(processListener);
    }

    protected void fireProcessEvent(ProcessEvent processEvent) {
        this.eventSupport.fireEvent(processEvent);
    }

    private static ProcessBuilder createProcessBuilder(String executable, String ... args) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command().add(executable);
        if (args != null) {
            for (String arg : args) {
                processBuilder.command().add(arg);
            }
        }
        return processBuilder;
    }
}

