/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.system.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.system.process.LineProcessor;
import oracle.install.commons.system.process.OutputConsumer;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessEvent;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.RawProcessor;
import oracle.install.commons.util.ProxyFactory;

public class ProcessLauncher {
    private static Logger logger = Logger.getLogger(ProcessLauncher.class.getName());
    private static ProcessLauncher instance = null;

    public static ProcessLauncher getInstance() {
        if (instance == null) {
            ProxyFactory proxyFactory = ProxyFactory.getInstance();
            instance = proxyFactory.createProxy(ProcessLauncher.class, new ProcessLauncher());
        }
        return instance;
    }

    protected ProcessLauncher() {
    }

    protected Process start(ProcessLaunchInfo processLaunchInfo) throws IOException {
        ProcessBuilder processBuilder = processLaunchInfo.getProcessBuilder();
        Process process = processBuilder.start();
        return process;
    }

    public int launchProcess(ProcessLaunchInfo processLaunchInfo) throws IOException, InterruptedException, NullPointerException, IllegalArgumentException {
        ProcessBuilder processBuilder = processLaunchInfo.getProcessBuilder();
        if (processBuilder == null) {
            throw new NullPointerException();
        }
        List<String> command = processBuilder.command();
        String executable = processLaunchInfo.getExecutable();
        OutputProcessor stdoutProcessor = processLaunchInfo.getStdoutProcessor();
        OutputProcessor stderrProcessor = processLaunchInfo.getStderrProcessor();
        logger.log(Level.INFO, "Executing {0} \n with environment variables {1}", new Object[]{command, processBuilder.environment()});
        Process process = this.start(processLaunchInfo);
        processLaunchInfo.fireProcessEvent(new ProcessEvent(process, ProcessEvent.Type.PROCESS_STARTED, processLaunchInfo));
        logger.log(Level.INFO, "Starting Output Reader Threads for process {0}", executable);
        OutputReaderThread stdoutThread = new OutputReaderThread(executable, process, stdoutProcessor, 1);
        stdoutThread.start();
        OutputReaderThread stderrThread = new OutputReaderThread(executable, process, stderrProcessor, 2);
        stderrThread.start();
        int exitCode = process.waitFor();
        logger.log(Level.INFO, "The process {0} exited with code {1}", new Object[]{executable, exitCode});
        processLaunchInfo.fireProcessEvent(new ProcessEvent(process, exitCode == 0 ? ProcessEvent.Type.PROCESS_COMPLETED : ProcessEvent.Type.PROCESS_FAILED, processLaunchInfo));
        logger.log(Level.INFO, "Waiting for output processor threads to exit.");
        stdoutThread.join();
        stderrThread.join();
        logger.log(Level.INFO, "Output processor threads exited.");
        return exitCode;
    }

    public static int launch(ProcessLaunchInfo processLaunchInfo) throws IOException, InterruptedException, NullPointerException, IllegalArgumentException {
        ProcessLauncher processLauncher = ProcessLauncher.getInstance();
        return processLauncher.launchProcess(processLaunchInfo);
    }

    private static class OutputReaderThread
    extends Thread {
        private InputStream in;
        private OutputProcessor outputProcessor;
        public static final int SOURCE_STDOUT = 1;
        public static final int SOURCE_STDERR = 2;

        public OutputReaderThread(String name, Process process, OutputProcessor outputProcessor, int source) {
            super("OutputReaderThread/" + (source == 1 ? "STDOUT" : "STDERR") + "/" + name);
            this.in = source == 1 ? process.getInputStream() : process.getErrorStream();
            this.outputProcessor = outputProcessor == null ? new OutputConsumer() : outputProcessor;
            this.outputProcessor.setProcess(process);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(this.in));
                this.outputProcessor.begin();
                if (this.outputProcessor instanceof LineProcessor) {
                    LineProcessor lineProcessor = (LineProcessor)this.outputProcessor;
                    String line = null;
                    int lineNumber = 0;
                    while ((line = bufferedreader.readLine()) != null) {
                        lineProcessor.processLine(line, ++lineNumber);
                    }
                } else {
                    RawProcessor rawProcessor = (RawProcessor)this.outputProcessor;
                    int size = rawProcessor.getBufferSize();
                    char[] data = new char[size + 1];
                    int nChars = 0;
                    while ((nChars = bufferedreader.read(data, 0, size)) != -1) {
                        rawProcessor.processData(data, nChars);
                    }
                }
                bufferedreader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.SEVERE, e.getMessage());
            }
            finally {
                this.outputProcessor.setProcess(null);
                this.outputProcessor.end();
                this.in = null;
                this.outputProcessor = null;
            }
        }
    }
}

