/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.util.ArrayList;
import java.util.List;
import oracle.install.commons.util.EventListener;
import oracle.install.commons.util.EventObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSupport<T> {
    private List<EventListener<T>> listeners = new ArrayList<EventListener<T>>();

    public void addEventListener(EventListener<T> listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeEventListener(EventListener<T> listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void fireEvent(T e) {
        if (e != null) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                EventListener<T> fel = this.listeners.get(i);
                fel.update(e);
            }
            if (e instanceof EventObject) {
                ((EventObject)e).release();
            }
        }
    }

    public void release() {
        this.listeners.clear();
        this.listeners = null;
    }
}

